appServer <- function(input,output,session){

  observeEvent(input$convertButton,{
    
    print(input$xlsxfiles)
    filename = input$xlsxfile[[1]]
    filepath = input$xlsxfile$datapath;
    print(filepath); cat("\n");
		excelData = read_xlsx(filepath);

		nFunctions = dim(excelData)[2]/2;
		nDatapoints = dim(excelData)[1]
    
    DataQualityTest = colnames(excelData)[1];
    
    if(DataQualityTest != "Function 1"){
         session$sendCustomMessage(type='testmessage',
                                    message = paste0(filename, " is not correctly formatted and could not be converted.")) 
    } else {
        	outfile_dataname = strsplit(filename,"[.]")[[1]][1];

		for(j in 1:nFunctions){

			outfile = paste0("..//",outfile_dataname,"_F",j,".csv");
			mz_col = 2*(j-1) + 1 ;
			ab_col = 2*(j-1) + 2 ;
			
			
			sink(outfile);
			for(k in 1:nDatapoints){
				if( is.na( as.numeric( excelData[k,mz_col][[1]] ) ) == FALSE ){ 
					cat(as.numeric(excelData[k,mz_col][[1]]));
					cat(",");
					cat(as.numeric(excelData[k,ab_col][[1]]));
					cat("\n");
				}
			}
			sink();
			cat("\n");
		}
    
    
    
          session$sendCustomMessage(type='testmessage',
                                    message = paste0(filename, " has been converted to parsed .csv files.")) 
    }
		
		
	
  })
  
  
  
  
  # What to do once app is closed
  session$onSessionEnded(function() {
    # # Get current working directory
    # pathout = getwd()
    # # Create filename and path
    # file = paste0(pathout, "LastSession.csv")
    # 
    # 
    # # Create an instance of current parameters to be saved
    # isolate({
    # 
    #   tempdf <- data.frame(input$entry1, 
    #                      input$entry2,
    #                      input$entry3,
    #                      input$entry4,
    #                      input$entry5,
    #                      input$target_min_ab/100, 
    #                      input$searchType,
    #                      input$target_type,
    #                      input$lowres,
    #                      input$epsilon_0,
    #                      rv_RefLibSelected
    #                      )
    #   })
    # 
    # # Save current parameters before closing to use next session
    # isolate(write.csv(tempdf, file))
    
    stopApp()
  })  
  
}