library(shinyFiles)
asm_GUI_xlsx2csvConverter <- tabPanel(
  "File Converter ",
  
  # Side bar for xlsx file input
  fluidRow(
    tags$head(tags$script(src = "message-handler.js")),
           column(6,
		  div(p("This software application parses xlsx files that contain multiple spectra, as produced using a Waters ACQUITY QDa Mass Detector. 
The parsed spectra are saved as individual csv files that can be used with the NIST/NIJ DART-MS Data Interpretation Tool. Please contact dartdata@nist.gov 
if you require other specialized data conversions.")),
		  br(),
                  div(p("Load .xlsx spectral data for conversion to .csv")),
                  div(style = "margin-top:-25px"),
                  fileInput("xlsxfile","",
                            multiple = FALSE,
                            placeholder = "xlsx  spectral data",
                            accept = ".xlsx"
                          ),
                  
                  actionButton("convertButton","Convert")
                  ),
           column(3)
  )
                      


) # End asm_GUI_xlsx2csvConverter
