## =============================================================================

# asm_sst_appServer.R 

# DESCRIPTION: 
    # The purpose of this program is to define the server end of the shiny app,
    # the other component being the app UI. This program uses helper functions,
    # inputs, outputs, observeEvents, eventReactives which are organized 
    # accordingly

# TABLE OF CONTENTS: 
    ##  BOTH TABS SOURCE CODE 
    #   - init_rv.R
    #   - getAxisLimits.R
  
    ##  LIBRARIES SOURCE CODE
    #   - Expanded view
    #   - Interactive view
    #   - mainPanel
    #   - sidebar
    
    ##  DATABASE SEARCH SOURCE CODE
    #   - Advanced Parameters
    #   - Expanded View
    #   - Interactive View
    #   - mainPanel
    #   - sidebar
    #   - Other

## =============================================================================

appServer <- function(input,output,session){
  
## =============================================================================
## BOTH TABS SOURCE CODE
## =============================================================================
  
    # Initialize reactive variable object 'rv' 
    source('source/ServerFunctions/init_rv.R', local=TRUE)
    
  # # Initialize reactive variable object 'rv' 
  # source('source/ServerFunctions/init_db.R', local=TRUE)
  
    # Get axis limits for current selection (DST and DBV)
    source('source/ServerFunctions/getAxisLimits.R', local=TRUE)
    
    # Get trigger button
    source('source/ServerFunctions/getTriggerButton.R', local=TRUE)
  
    # Get hashID for expanded  targets
    source('source/ServerFunctions/getHashID.R', local=TRUE)
  
  
## =============================================================================
## LIBRARIES SOURCE CODE
## =============================================================================
    ## -------------------------------------------------------------------------
    ## Expanded View
    ## -------------------------------------------------------------------------
    
    # Create the plot outputs for expanded view
    source('source/ServerFunctions/DataViewer/expanded_LibraryPlots.R', 
           local=TRUE)
    
    # Create the peak lists for expanded view
    source('source/ServerFunctions/DataViewer/expanded_PeakList_DBV.R', 
           local=TRUE)
    
    ## -------------------------------------------------------------------------
    ## Interactive View
    ## -------------------------------------------------------------------------
  
    # Create the plots for interactive tab
    source('source/ServerFunctions/DataViewer/interactive_LibraryPlots.R', 
           local=TRUE)
    
    # plot tab
    source('source/ServerFunctions/DataViewer/interactive_LibraryPlotsTab.R', 
           local=TRUE)
    observeEvent(input$plottab, plottab(input))
    
    # Peak List for UI
    source('source/ServerFunctions/DataViewer/interactive_PeakList_DBV.R', 
           local=TRUE)
    
    # Peak List for UI
    source('source/ServerFunctions/DataViewer/interactive_PeakListTab_DBV.R', 
           local=TRUE)
    
    ## -------------------------------------------------------------------------
    ## mainPanel 
    ## -------------------------------------------------------------------------
    
    # Update libraryData by renderTable
    source('source/ServerFunctions/DataViewer/mainPanel_Library.R', 
           local=TRUE)
    
    # Structure plot
    source('source/ServerFunctions/DataViewer/mainPanel_structurePlotter.R', 
           local=TRUE)
    
    # Toggle between Interactive and Expanded View 
    source('source/ServerFunctions/DataViewer/mainPanel_toggle_DBV.R', 
           local=TRUE)
    observeEvent(input$toggle_DBV, toggle_DBV(input))
  
  
    ## -------------------------------------------------------------------------
    ## sidebar 
    ## -------------------------------------------------------------------------
    
    # Initialize the library
    source('source/ServerFunctions/DataViewer/sidebar_Library.R', 
           local=TRUE)
    
    # Select library rows
    source('source/ServerFunctions/DataViewer/sidebar_LibraryRows.R', 
           local=TRUE)
    observeEvent(input$Library_rows_selected, library_rows(input, rv))
    
    # RefLibSelect for DBV tab
    source('source/ServerFunctions/DataViewer/sidebar_RefLibselect.R', 
           local=TRUE)
    # observeEvent(input$RefLibSelect, RefLibSelectDBV(input, rv))
  
    
    
## =============================================================================   
## DATABASE SEARCH SOURCE CODE  
## =============================================================================
    ## -------------------------------------------------------------------------
    ## SEARCH SETTINGS
    ## -------------------------------------------------------------------------
    # Load search settings for lowres, search type, hiding targets,
    # target_min_ab, and epsilon_0
    source('source/ServerFunctions/DataSearch/Advanced_Settings.R', local=TRUE)

    ## -------------------------------------------------------------------------
    ## Expanded View
    ## -------------------------------------------------------------------------
    # Create condensed table for params, filenames and fields in expanded view
    source('source/ServerFunctions/DataSearch/expanded_Fields.R', local=TRUE)
    
    # Create the peak list based on selected tab from interactive
    source('source/ServerFunctions/DataSearch/expanded_PeakList.R', local=TRUE)
    
    # Create expanded view plots for 60 and 90V spectra (helper function)
    # WARNING: helper function must come before expanded_QueryPlots.R
    source('source/ServerFunctions/DataSearch/expanded_Plots.R', local=TRUE)
    
    # Create the plots in expanded view
    source('source/ServerFunctions/DataSearch/expanded_QueryPlots.R', 
           local=TRUE)

    ## -------------------------------------------------------------------------
    ## Interactive View
    ## -------------------------------------------------------------------------
    # Peak List for interactive view and UI
    source('source/ServerFunctions/DataSearch/interactive_PeakList.R', 
           local=TRUE)
    
    # Create the tabs 30, 60, 90 V for uiOutput("QueryPlotsUI")
    source('source/ServerFunctions/DataSearch/interactive_QueryPlots.R', 
           local=TRUE)
    
    ## -------------------------------------------------------------------------
    ## mainPanel 
    ## -------------------------------------------------------------------------
  
    # Load in the output downloadhandler for saving presets
    source('source/ServerFunctions/DataSearch/mainPanel_downloadpresets.R', 
           local=TRUE)
    
    # This observeEvent loads in the file and updates user input parameters
    source('source/ServerFunctions/DataSearch/mainPanel_Loadparams.R', 
           local=TRUE)

    # Restore Defaults for all settings and clear search
    source('source/ServerFunctions/DataSearch/mainPanel_RestoreDefaults.R', 
           local=TRUE)

    # Toggle between Interactive and Expanded View 
    source('source/ServerFunctions/DataSearch/mainPanel_Toggle_DST.R', 
           local=TRUE)

    
    ## -------------------------------------------------------------------------
    ## sidebar 
    ## -------------------------------------------------------------------------
    # EventReactive - update reactive values and after hitting 'Search Database'
    # Trigger_button does all computing
    source('source/ServerFunctions/DataSearch/sidebar_Trigger_Button.R', 
           local=TRUE)
    observeEvent(input$DartSearch, trigger_button())
    observeEvent(input$DartSearchAdv, trigger_button2())
    
    # Load trigger button helper functions
    source('source/ServerFunctions/DataSearch/sidebar_TriggerButtonHelpers.R', 
           local=TRUE)
    
    # Load trigger button helper functions
    source('source/ServerFunctions/DataSearch/Trigger_Calculations.R', 
           local=TRUE)

    # Load trigger button helper functions
    source('source/ServerFunctions/DataSearch/sidebar_TriggerDevMode.R', 
           local=TRUE)
    
    # RefLibSelect for DST tab
    source('source/ServerFunctions/DataSearch/sidebar_RefLibselect.R', 
           local=TRUE)
    # observeEvent(input$RefLibSelect_DST, RefLibSelectDST(input, rv))
    
    # Classes select dropdown menu
    source('source/ServerFunctions/DataSearch/sidebar_ClassesSelect.R', 
           local=TRUE)
    observeEvent(input$ClassesSelect, ClassesSelect(input, rv))
    
    
    # Clear search and parameters not loaded in a preset file
    source('source/ServerFunctions/DataSearch/sidebar_ClearSearch.R', 
           local=TRUE)
    observeEvent(input$clearSearch, clearSearch(input))
  
    # Clear search and parameters not loaded in a preset file
    source('source/ServerFunctions/DataSearch/sidebar_FileInputs.R',
           local=TRUE)
    
    ## ---------------------------------------------------------------------------
    ## Other 
    ## ---------------------------------------------------------------------------

    # All other elper functions and misc. are stored here
    source('source/ServerFunctions/DataSearch/Other_HelperFunctions.R', 
           local=TRUE)
    
    # Session ending and final closing events are defined here
    source('source/ServerFunctions/DataSearch/Other_SessionEnd.R', 
           local=TRUE)
    
    source('source/ServerFunctions/DataSearch/Trigger_Targets.R', 
           local=TRUE)
    
    
    ## =============================================================================   
    ## DATABASE VIEWER SOURCE CODE  
    ## =============================================================================

    # source('source/ServerFunctions/Database/Trigger_AddSearch.R', 
    #        local=TRUE)
    # 
    # source('source/ServerFunctions/Database/mainPanel_DatabaseViewer.R', 
    #        local=TRUE)    
    # 
    # 
    # source('source/ServerFunctions/Database/DBAdmin_Settings.R', 
    #        local=TRUE)    
}







