## =============================================================================

# TITLE: asm_externalPackages.R

# DESCRIPTION: 
# The purpose of this code is to install packages that the source code
# depends on for running. This code is run at the initial code startup & if
# any packages are missing from the environment they are installed here

## =============================================================================

# library(DBI)
# library(dplyr)

if("tidyverse" %in% row.names(installed.packages())==FALSE){
  install.packages("tidyverse",dependencies=TRUE);
  library("tidyverse");
} else {
  library(tidyverse)
}

if("DBI" %in% row.names(installed.packages())==FALSE){
  install.packages("DBI",dependencies=TRUE);
  library("DBI");
} else {
  library(DBI)
}

if("dplyr" %in% row.names(installed.packages())==FALSE){
  install.packages("dplyr",dependencies=TRUE);
  library("dplyr");
} else {
  library(dplyr)
}

# rShiny package used for making interactive web applications
if("shiny" %in% row.names(installed.packages())==FALSE){
  install.packages("shiny",dependencies=TRUE);
  library("shiny");
} else {
  library(shiny)
}

# shinyjs used for integrating javascript in web app
if("shinyjs" %in% rownames(installed.packages())==FALSE){
  install.packages("shinyjs")
  library(shinyjs)
} else {
  library(shinyjs)
}

# shinythemes used for customizing themes of the web app
if("shinythemes" %in% rownames(installed.packages()) == FALSE){
  install.packages("shinythemes")
  library(shinythemes)
} else {
  library(shinythemes)
}

# data.table is used for creating data frames for data organization
if("data.table" %in% rownames(installed.packages()) == FALSE) {
  install.packages("data.table")
  library(data.table)
} else {
  library(data.table)
}

# devtools used for github install 
if("devtools" %in% row.names(installed.packages())==FALSE){
  install.packages("devtools",dependencies=TRUE)
  library(devtools)
} else{
  library(devtools)
}

# DT used for creating datatables within rshiny framework
# allows for more customizability than dataframes
if("DT" %in% row.names(installed.packages())==FALSE){
  devtools::install_github('rstudio/DT');
  library(DT);
} else {
  library(DT);
}

# httr used for working with URLs and HTTP within rshiny framewwork
if("httr" %in% row.names(installed.packages())==FALSE){
  install.packages("httr",dependecies=TRUE);
  library("httr")
} else {
  library("httr")
}

# plotly is used for generating plots with annotations and customizations
if("plotly" %in% row.names(installed.packages())==FALSE){
  install.packages("plotly",dependencies=TRUE);
  library("plotly")
} else {
  library("plotly")
}

# ggplot2 allows for interactive plots with custom themes
if("ggplot2" %in% row.names(installed.packages())==FALSE){
  install.packages("ggplot2")
  library(ggplot2)
} else {
  library(ggplot2)
}

# ggrepel package used for plot annotations that are self repelling
if("ggrepel" %in% row.names(installed.packages())==FALSE){
  install.packages("ggrepel")
  library(ggrepel)
} else {
  library(ggrepel)
}

# ggtext element_markdown theme for plot text customization 
if("ggtext" %in% row.names(installed.packages())==FALSE){
  install.packages("ggtext")
  library(ggtext)
} else {
  library(ggtext)
}

# stringr package is used for reading and manipulating string data
if("stringr" %in% row.names(installed.packages())==FALSE){
  install.packages("stringr")
  library(stringr)
} else {
  library(stringr)
}
