## =============================================================================

# TITLE: asm_appUI.R

# DESCRIPTION: 
# The purpose of this function is to load the GUI tabs for Database
# viewer and search as well as the about tabs. These components are packaged
# into the shinyUI appUI as part of the navbarPage

## =============================================================================

# Load GUI programs
source('source/GUI/asm_sst_GUI_DST.R')   # Database Search
source('source/GUI/asm_GUI_DBV.R')   # Database Viewer
source('source/GUI/sst_GUI_SCORING.R') # Disclaimer messages and contact
# source('source/GUI/sst_GUI_DATABASE.R')
source('source/GUI/sst_GUI_ABOUT.R') # Disclaimer messages and contact

# Package appUI 
appUI <- shinyUI({
  # Define image banner, style, title, and navbarPage
  fixedPage(theme=shinytheme("flatly"),
            shinyjs::useShinyjs(),
            list(tags$head(HTML('<link rel="icon", href="DIT-LOGO.png",
                                  type="image/png" />'))),
            div(style="padding: 1px 0px; width: '100%'", titlePanel(
              title="",windowTitle="NIST/NIJ DART-MS DIT")),
            div(p(img(src="DIT-Banner.png",width="70%")),align="center"),
            navbarPage(" ",
                       asm_GUI_DST,
                       asm_GUI_DBV,
                       sst_GUI_SCORING,
                       # sst_GUI_DATABASE,
                       sst_GUI_ABOUT
            )
  )
})