## =============================================================================

# TITLE: asm_Header.R

# DESCRIPTION: 
# The purpose of this program is to load  functions, disclaimer messages,
# library data, and previous session data needed BEFORE the app UI is called
# This program is also where dev_mode and lb_mode are turned on and off

# TABLE OF CONTENTS: 
# 1) LOAD FUNCTIONS
# 2) INIT GLOBAL VARIABLES
# 3) GET PREVIOUS SESSION DATA
# 4) INIT LIBRARY, CLASS LIST, INDICES
#     - 4a) Initialize library and characterstic vars 
#     - 4b) Make class list
#     - 4c) Get library specific indices

## =============================================================================
## 1) LOAD FUNCTIONS 
## =============================================================================

# Set modes 
dev_mode = 0  # set to 1 to see extended scoring break down and other notes
lb_mode  = 0  # future work: add "library builder" as a third tab 
# File types accepted
query_file_types = c(".txt",".jsp",".csv");


# load plaintext messages and dev mode message
source("source/sst_Disclaimers.R")

# load custom written functions relevant to server
source("source/ServerFunctions/findUniqueClasses.R")
source("source/ServerFunctions/checkNegativeLibrary.R")

# load custom written functions for calculations in trigger button
source("source/Functions/asm-spec2dt.R")
source("source/Functions/asm-bpNormalizer.R")
source("source/Functions/asm-targetMolecules.R")
source("source/Functions/asm-spec2dt_ref.R")
source("source/Functions/asm-revMatchFactor.R")
source("source/Functions/asm-PeaksExplained.R")
source("source/Functions/asm-specImport.R")
source("source/Functions/asm-clc.R")
source("source/Functions/asm-mass-diff.R")
source("source/Functions/asm-hiRes2lowRes.R")
source("source/Functions/asm_isotopeDiffCalculator.R")
source("source/Functions/sst-mass-diff.R")
source("source/Functions/asm_ILSA.R")
source("source/Functions/asm-Scoring.R")


## =============================================================================
## 2) INIT GLOBAL VARIABLES 
## =============================================================================

# Clear console
clc()

# Initial Definitions for some key user or reactive variables
MAX_TARGETS = 200
m_neutron = 1.00866
noiseThreshold = 0.01
# o.maxXval = ceiling(as.numeric(RefLibrary[1,iPrecursorMZ,with=FALSE][[1]]))
# o.minXval = 50

# Select Initial Library to view/search against 
Libraries = list.files("Libraries")

# Set up reactive value
rv <- reactiveValues()
# db <- reactiveValues()

## =============================================================================
## 3) GET PREVIOUS SESSION DATA 
## =============================================================================    

# Load selected library from previous session
lastsession_path <<- '../shiny_DITLastSession.csv'
# See if file exists
if (file.exists(lastsession_path)){
  # Load data
  dat <<- read.csv(file = lastsession_path)
  # If a library was selected last session
  if (isTruthy(dat$rv_RefLibSelected)){
    rv_RefLibSelected <<- dat$rv_RefLibSelected
  } else {
    # Otherwise default to first library in list
    rv_RefLibSelected <<- Libraries[1]
  }
  # Load previous session into global variables
  entry1 <<- dat$input.entry1
  entry2 <<- dat$input.entry2
  entry3 <<- dat$input.entry3
  entry4 <<- dat$input.entry4
  entry5 <<- dat$input.entry5
  init_tminab <<- dat$input.target_min_ab*100
  # init_searchType <<- dat$input.searchType
  # init_targetType <<- dat$input.target_type
  
  init_lowres <<- dat$input.lowres
  init_epsilon <<- dat$input.epsilon_0
  init_hideTargets <<- dat$rv.hideTargets
  
  # # Check if an error in library mode and init_targetType
  # if (init_targetType == "Protonated Molecule" && isNeg(rv_RefLibSelected)){
  #   init_targetType = "Deprotonated Molecule"
  # } else if (
  #   init_targetType == "Deprotonated Molecule" && !isNeg(rv_RefLibSelected)){
  #   init_targetType = "Protonated Molecule"
  # }
  
  # If loaded preset is empty, tag that preset to be cleared
  if (dat$input.entry1 == "" || is.na(dat$input.entry1)){
    tf1 <<- NA
  } else {
    tf1 <<- dat$input.entry1
  }
  
  if (dat$input.entry2 == "" || is.na(dat$input.entry2)){
    tf2 <<- NA
  } else {
    tf2 <<- dat$input.entry2
  }   
  
  if (dat$input.entry3 == "" || is.na(dat$input.entry3)){
    tf3 <<- NA
  } else {
    tf3 <<- dat$input.entry3
  }   
  
  if (dat$input.entry4 == "" || is.na(dat$input.entry4)){
    tf4 <<- NA
  } else {
    tf4 <<- dat$input.entry4
  }   
  
  if (dat$input.entry5 == "" || is.na(dat$input.entry5)){
    tf5 <<- NA
  } else {
    tf5 <<- dat$input.entry5
  }
  
  
  
  
  # #~# DB - find previous session settings
  # db$name = dat$db.name
  # db$onOff = dat$db.onOff
  
} else {
  # if no previous session, load default settings
  rv_RefLibSelected <<- Libraries[1]
  tf1 <<- tf2 <<- tf3 <<- tf4 <<- tf5 <<- NA
  entry1 <<- entry2 <<- entry3 <<- entry4 <<- entry5 <<- ""
  init_tminab <<- 5
  # init_searchType <<- "ma"
  # init_targetType <<- "Protonated Molecule"
  # 
  # # Check if negative library
  # if (isNeg(rv_RefLibSelected)){
  #   init_targetType <<- "Deprotonated Molecule"
  # }
  
  init_lowres <<- FALSE
  init_epsilon <<- 0.005
  init_hideTargets <<- FALSE
  
  # #~#
  # db$name = ""
  # db$onOff = FALSE
}


## =============================================================================
## 4) INIT LIBRARY, CLASS LIST, INDICES
## =============================================================================
## -------------------------------------------------------------------------
## 4a) Initialize library and characteristic vars 
## -------------------------------------------------------------------------

update_LibraryMode(rv_RefLibSelected)

## -------------------------------------------------------------------------
## 4b) Make class list 
## -------------------------------------------------------------------------

# Find unique classes using helper function for drop down select input
classesTable = find_unique_classes(init_lib)
# Set class_selected global variable to all classes initially
class_selected <<- classesTable
numClasses <<- dim(classesTable)[1]

# For debugging Classes
# print(paste0("num classesB: ", numClasses))
# print(paste0("length class_selectedB: ", dim(class_selected)[1]))

## For finding last session class selection 
lastsessionclasses_path <<- '../shinyLastSessionClasses.csv'
if (file.exists(lastsessionclasses_path)){
  dat2 <<- read.csv(file = lastsessionclasses_path)
  
  class_selected <<- dat2$class_selected
}

## -------------------------------------------------------------------------
## 4c) Get library specific indices 
## -------------------------------------------------------------------------

# Identify indices for each column in the library data table
# LibraryCats = colnames(initial_RefLibrary)
LibraryCats = colnames(init_lib)
iCode = which(LibraryCats=="Code")
iName = which(LibraryCats=="Name")
iFormula = which(LibraryCats=="Formula")
iFormulaSub = which(LibraryCats=="formulasubscript")
iInChIKey = which(LibraryCats=="InChIKey_gen")
iPrecursorMZ = which(LibraryCats=="PrecursorMZ_gen")
iDimerProb = which(LibraryCats=="DimerProb")
iSmiles = which(LibraryCats=="SMILES")
iPotentialErrors = which(LibraryCats=="PotentialErrors")
iMassCaliError = which(LibraryCats=="MassCaliError")
iPotentialErrorsFM1 = which(LibraryCats=="PotentialErrorsFM1" )
iExactMass = which(LibraryCats=="AccurateMass_gen")
iStructure = which(LibraryCats=="Structure_gen")
iNoiseMetric = which(LibraryCats=="NoiseMetric")
iBP = which(LibraryCats=="theoBP")
iSynonym = which(LibraryCats=="Synonyms")
iEnergies = which(LibraryCats=="Energies")
iPolarity = which(LibraryCats=="polarity")
iSourceGas = which(LibraryCats=="sourceGas")
# minEnFolder = initial_RefLibrary[1,iEnergies,with=FALSE][[1]][[1]][1]
minEnFolder = init_lib[1,iEnergies,with=FALSE][[1]][[1]][1]
epsilon_0 <<- 1.0 


## =============================================================================
## 5) Open connection to database
## =============================================================================

# db_path <<- 'test.sqlite'
# # See if file exists
# if (file.exists(db_path)){
# # Connect to database using con. dbname = Database name saved into working dir
# con <<- DBI::dbConnect(RSQLite::SQLite(),
#                        user = 'root',
#                        password = '',
#                        dbname = db_path,
#                        host = 'localhost')
# 
#   rv$dbEmpty = FALSE
# 
# } else {
#   con <<- NULL
#   rv$dbEmpty = TRUE
#   
# }

