
## =============================================================================

# TITLE: init_rv.R

# DESCRIPTION: 
    # This program initializes the reactive values and global variables 
    # that are updated by the user while using the application. rv fields are 
    # updated reactively through use of the aplication. Global fields and 
    # global data structures are updated only when trigger button is selected


## =============================================================================
## WARNINGS
## =============================================================================
    
    # - rv is now instantiated in asm_Header.R
    # - 'PLOTTING' variables must come after REPORTING VIEW 

## =============================================================================
## VARIABLES 
## =============================================================================

## LIBRARY & COLUMN INDICES
# Identify indices for each column in the library data table 
    rv$RefLibrary_rv <- init_lib
    rv$LibraryCats <- LibraryCats
    rv$iCode <-iCode 
    rv$iName <- iName 
    rv$iFormula <- iFormula
    rv$iInChIKey <- iInChIKey
    rv$iPrecursorMZ <- iPrecursorMZ
    rv$iDimerProb <- iDimerProb
    rv$iSmiles <- iSmiles
    rv$iPotentialErrors <- iPotentialErrors 
    rv$iMassCaliError <- iMassCaliError
    rv$iPotentialErrorsFM1 <- iPotentialErrorsFM1
    rv$iExactMass <- iExactMass
    rv$iStructure <- iStructure
    rv$iNoiseMetric <- iNoiseMetric
    rv$iBP <- iBP
    rv$iSynonym = iSynonym
    rv$iEnergies <- iEnergies
    rv$minEnFolder <- minEnFolder

## UI SELECTIONS
    # Initial tab selections and ui elements on start
    rv$compoundSelected <- 1
    rv$energySelected <- "Low (30 V)" #Dataviewer
    rv$QuerySelected <- "Low (30 V)" #DataSEarch
    rv$pltabSelected <- "Top 10"
    rv$tabSelected <- "Target 1"
    rv$pltabSelected_DBV <- "Top 10"
    # Hide until search init
    hide("pl")
    hide("expanded_plot_row")

## SEARCH SETTINGS
# Advanced search parameters under the 'settings' tab
    # rv$search_type = "ma"
    # rv$target_type = "Search not yet conducted"
    rv$target_type = "Protonated Molecule"
    
    rv$mz_tol = 1.0;
    rv$target_min_ab = 0.05
    rv$numTargets <- 1;
    rv$targets_mz <- NULL
    rv$targets_in <- NULL
    rv$hideTargets = FALSE
    # rv$mAndHPrint = NULL

# FILE UPLOADS
    # All variables that handle file uploads from the search tab
    rv$datapathq30 <- rv$datapathq60 <- rv$datapathq90 <- ""
    # tell whether different combination of file uploads present
    NumSpectra <<- 3
    rv$case_A = 0
    # Data stored in these
    rv$bpN_Query1 <- NULL
    rv$bpN_Query2 <- NULL
    rv$bpN_Query3 <- NULL

## TRIGGER SELECTION
    # currtrigger 1 for 'Search Database' button
    # currtrigger 2 for 'Update Search' button
    rv$currtrigger <- 0

## TARGETS
    allTargets.list <<- NULL
    showidx <<- NULL
    rv$state1 = FALSE
    rv$state2 = FALSE
    rv$state3 = FALSE

# REPORTING VIEW 
    # Final fields after trigger button is pressed, not updated reactively
    rv$fileq30 <- rv$fileq60 <- rv$fileq90 <- "No file selected"
    fileq30print <- fileq60print <- fileq90print <- "No file selected"
    target_min_ab_print = NULL
    target_type_print = NULL
    lowres_print = NULL
    mz_tol_print = NULL
    RefLibraryPrint <<- NULL
    hideTargetsPrint <<- NULL
    xmin_dst_print <<- 0
    xmax_dst_print <<- 0
    xmintick_dst_print <<- 0
    xmaxtick_dst_print <<- 0
    increment_dst_print <<- 0

## PLOTTING VARIABLES 
    # All variables to do with plots
    rv$annotations = ""
    rv$x = ""
    cutoff <<- target_min_ab_print*100
    target_annotations_vals <<- NULL
    target_annotations_labels <<- NULL
    target_annotations <<- NULL
    # For plot axes
    rv$increment_dst <- 50
    rv$xmin_dst <- 0
    rv$xmax_dst <- 350
    rv$xmintick_dst <- 0
    rv$xmaxtick_dst <- 400
    rv$xmin_dbv <- 0
    rv$xmax_dbv <- 350
    rv$xmintick_dbv <- 0
    rv$xmaxtick_dbv <- 400
    
## Database
    # rv$searchSelected = 1
