## =============================================================================

# TITLE: getTriggerButton.R

# DESCRIPTION: 
    # The purpose of this program is to differentiate the rv$currtrigger based  
    # on which search button is pressed. rv$currtrigger equals 1 if 
    # "Search database" button is pressed, and 2 if "Update Search" is pressed 
    # within the settings tab

## =============================================================================


getTriggerButton <- function(){
  
  # Select between two separate trigger buttons
  if (rv$currtrigger == 1) { 
    trigger_button()
    
  } else if (rv$currtrigger == 2) {
    trigger_button2()
    
  } else {
    # If trigger not clicked yet, return FALSE, don't do anything yet
    return(FALSE)
  }
}


## unpackResults ###############################################################
# multiple returned parameters must be unpacked since R is incapable of doing so
# without aggregates ie. c() or list()
unpackResults <- function(i, result){
  if (is.null(result[[i]])){
    return(NULL)
  } else {
    return(result[[i]])
  }
}