
## =============================================================================

# TITLE: getHashID.R

# DESCRIPTION: 
# This program has two helper functions. The first either shows or hides all of
# the expanded target outputs depending on which mode is passed in. The second
# helper function gets the id of the expanded target output depending on hashing
# since there are two outputs saved in a list of outputs for each target. 

# For more information on expanded target outputs, please see 
# source/ServerFunctions/DataSearch/Trigger_Targets.R

#                             TABLE OF cONTENTS: 
#
#     1) SHOW/HIDE EXPANDED TARGETS
#     2) GET HASH ID OF OUTPUT

## =============================================================================
##                      1) SHOW/HIDE EXPANDED TARGETS
## =============================================================================

showHide_showidx <- function(showidx, mode){
  # Hide all targets to clear the main panel from previous searches
  for (i in 1:length(showidx)) {
    local({
      i <- i
      # Find the hashed index (since there are 2 outputs for each target)
      idx = get_hashedID(showidx, i)
      id = paste0("dt", idx)
      idplus = paste0("dt", idx + 1)
      
      if (mode == 1){
        # Hide outputs
        hide(id)
        hide(idplus)
      } else {
        # Show outputs if mode == 2
        show(id)
        show(idplus)
      }
    })
  }
}

## =============================================================================
##                       2) GET HASH ID OF OUTPUT
## =============================================================================

get_hashedID <- function(showidx, i){
  if (length(showidx) == 0){
    idxtohash = 1
  } else {
    idxtohash = showidx[i]
  }
  idx = (idxtohash*2)-1
  return(idx)
}
