## =============================================================================

# TITLE: getAxisLimits.R

# DESCRIPTION: 
    # This helper function gets the axis limits of all interactive plots to 
    # allow for all plots to have the same x-axis range

## =============================================================================

getAxisLimits <- function(bpn_data, axisLimits, i){
  
  # Get x-axis limits for this graph by creating a temporary plot
  cat(paste0("\n\nIn getAxisLimits.R: Line 14: bpn_data=\n"))
  for(test in 1:dim(bpn_data)[1]){
    cat(paste0(bpn_data[test,1],"\t",bpn_data[test,2],"\n"))
  }
  cat("\n")
  
  
  ptemp <- ggplot(bpn_data, aes(x = mz, y = ab, ymax = ab, ymin = 0))
  xlimits = ggplot_build(ptemp)$layout$panel_params[[1]]$x.range
  ylimits = ggplot_build(ptemp)$layout$panel_params[[1]]$y.range
  
  cat(paste0("\n\nIn getAxisLimits.R: Line 16: ylimits =",ylimits[2],"\n"))
  # Save axis limits  to return
  axisLimits$xmin[i] <- max(xlimits[1], 0)
  axisLimits$xmax[i] <- xlimits[2]
  axisLimits$ymin[i] <- ylimits[1]
  axisLimits$ymax[i] <- ylimits[2]
  
  # print(paste0("xaxis: ", max(xlimits[1],0), "-", xlimits[2]))
  # print(paste0("yaxis: ", ylimits[1], "-", ylimits[2]))

  return(axisLimits)
}