# The purpose of this function is to calculate unique classes for the 
# currently selected library at initialization (asm_Header.R) and whenever the
# library selection is changed (sidebar_RefLibSelected.R)

find_unique_classes <- function(init_lib){
  # Initialize list of unique classes for dropdown menu in ClassesSelect input
  classList = unique(init_lib[,Class])
  classList = sort(classList)
  len = length(classList)
  classesTable = data.frame(classes = character(len))
  # add classes to the datastructure
  for (i in 1:len){
    classesTable$classes[i] = classList[i]
  }

  return(classesTable)
}