## =============================================================================

# TITLE: checkNegativeLibrary.R

# DESCRIPTION: 
#     This function checks if the currently selected library is a negative mode
#     library by first using readRDS to read the library, then looking for a 
#     negative value in the polarity column. If the library is negative, then 
#     certain variables will be updated accordingly. 

#     WARNING: This function is only called when a new library is loaded 
#     (passed in to this function). This occurs in all RefLibSelect.R files, and
#     on start up when the app is loaded. 

#     Search "negLibrary" using [Ctrl+Shift+f] to see all occurrences of 
#     negative library checks that are done even when the library isn't changed
#     ie. when Restore Defaults is pressed, or on session end. 

## =============================================================================


isNeg <- function(rv_RefLibSelected){
  # Read in library
  init_lib <<- readRDS(paste0("Libraries/", rv_RefLibSelected))
  
  # See if library is negative (TRUE) or positive (FALSE)
  negLibrary = any(init_lib[,polarity] == "Negative")
  
  # If library is negative
  if (negLibrary){
    return(TRUE)
  } else {
    return(FALSE)
  }
}

update_LibraryMode <- function(rv_RefLibSelected){
  # Read in library
  init_lib <<- readRDS(paste0("Libraries/", rv_RefLibSelected))
  
  # See if library is negative (TRUE) or positive (FALSE)
  # negLibrary = any(init_lib[,polarity] == "Negative")
  # Track if last session was base peak vs De/Protonated target assumption
  # init_targetTypeSelect <<- init_targetType
  # 
  # # If library is negative
  # if (negLibrary){
  #   rv$polarityPrint = "Negative"
  #   init_targetType <<- "Deprotonated Molecule"
  #   rv$mAndH = "[M-H]<sup>-</sup>"
  #   rv$mAndHLib = "[M-H]<sup>-</sup> (<em>m/z</em>): "
  # } else {
    # If positive library
    rv$polarityPrint = "Positive"
    init_targetType <<- "Protonated Molecule"
    rv$mAndH = "Ref <em>m/z</em>"
    rv$mAndHLib = "[M+H]<sup>+</sup> (<em>m/z</em>): "
  # }
}

basePeakHandler <- function(input, session){
  # if (input$target_type == "Protonated Molecule" || 
  #     input$target_type == "Deprotonated Molecule"){
  #   init_targetTypeSelect <<- init_targetType
  # } else {
  #   init_targetTypeSelect <<- "Base Peak"
  #   
  # }
  # 
  # # Update radio button selection
  # updateRadioButtons(session, inputId = "target_type",
  #                    choices = c(init_targetType, "Base Peak"),
  #                    selected = init_targetTypeSelect)
}