
## -----------------------------------------------------------------------------
## Database Outputsa and observeEvents
## -----------------------------------------------------------------------------
# Example to access and display result
# 
# output$idtable <- DT::renderDataTable({
#   # dbLoadIDTable()
#   
# 
# })



# Get currently selected  row from idtable output using idtable_rows_selected
observeEvent(input$idtable_rows_selected, {
  req(rv$dbEmpty == FALSE)
  
  rv$searchSelected  = input$idtable_rows_selected
  
  db$selectedSearch = dbGetQuery(con, paste0("SELECT id FROM ID_Table LIMIT ", rv$searchSelected - 1, ",1"))
})

# Display selected row name
output$ActiveDbSelection <- renderUI({

  HTML(paste0("<b>Selected Entry:</b> ",  db$selectedSearch, "<br>"
  ))
})

observeEvent(rv$searchSelected, {
  req(rv$dbEmpty == FALSE)
  
  # Get currently selected row index 
  rowid = dbGetQuery(con, paste0("SELECT * FROM ID_Table LIMIT ", rv$searchSelected - 1, ",1"))
  rv$result_1 = dbGetQuery(con, paste0("SELECT * FROM Query1 WHERE id LIKE '", rowid, "'"))
})








observeEvent(rv$result_1, {
  req(rv$dbEmpty == FALSE)
  
  # Get currently selected row index 
  rowid = dbGetQuery(con, paste0("SELECT * FROM ID_Table LIMIT ", rv$searchSelected - 1, ",1"))
  # Get targets table of current search
  rv$result_5 = dbGetQuery(con, paste0("SELECT * FROM Targets_Table WHERE id LIKE '", rowid, "'"))
  
  rv$result_6 = dbGetQuery(con, paste0("SELECT * FROM Metadata_Table WHERE id LIKE '", rowid, "'"))
  print(paste0("rv$result_6 A: ", rv$result_6))
  
})

output$PeakList_30v_db <- DT::renderDataTable({
  req(rv$dbEmpty == FALSE && isTruthy(rv$searchSelected))
  
  bpn_data = rv$result_1
  
  bpn_data = data.frame(mz = rv$result_1[,2], ab = rv$result_1[,3])
  bpn_data = bpn_data[order(-bpn_data$ab),]
  bpn_data$labels = rv$result_1[,4]

  bpn_data = format_peakList(bpn_data, "Low (30 V)")
  
  },
  selection = 'single',
  escape = FALSE,      
  rownames = FALSE,
  options = list(dom  = 'ltp',
                 autowidth=TRUE,
                 # columnDefs = list(list(width='100px', targets = c(2))),
                 rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}"),
                 lengthMenu = list(c(10, 30, -1), c('10', '30', 'All Peaks'))
  )
)



# Plot a plot of the current selection
output$DBTestPlot <- renderPlot({
  req(rv$dbEmpty == FALSE && isTruthy(rv$searchSelected))

  # Get data for first query
  bpn_data = rv$result_1
  bpn_data = data.frame(mz = rv$result_1[,2], ab = rv$result_1[,3])
  
  
  # Create annotated plot with data and title parameters
  # rv$targets_mz[[1]] is for targets
  q = create_ggplot_db(bpn_data, rv$result_6[2], rv$result_5[,2])
  # rv$result_5[[1]])
  
  return(q)
})

