
addToDB_SQL <- function(){
  
  # Check if a database exists, if not create one
  db_path <<- 'backupTest.sqlite'
  # See if file exists
  if (!file.exists(db_path)){

    # Connect to database using con. dbname = Database name saved into working dir
    con <<- DBI::dbConnect(RSQLite::SQLite(),
                           user = 'root',
                           password = '',
                           dbname = 'test.sqlite',
                           host = 'localhost')

    rv$dbEmpty = FALSE

  }
  
  # Initialize important variables
  listlengths = NULL
  # Generate a unique id for this search to be used in all tables 
  uniqueid = format(Sys.time(), "%H%M%S_%m-%d-%Y")
  # Important variables 
  MONTHS = c("January", "February", "March", "April", "May", "June", "July", 
             "August", "September", "October", "November", "December")
  
  # Modify ID Table, extract different date elements here
  day = substring(uniqueid, 11, 12)
  month = substring(uniqueid, 8, 9)
  year = substring(uniqueid,14 ,17)
  hh = substring(uniqueid,1,2)
  mm = substring(uniqueid, 3,4)
  ss = substring(uniqueid, 5,6)
  
  month = MONTHS[as.numeric(month)]
  if (hh >= 13){
    ampm = "PM"
    hh = as.character(as.numeric(hh) - 12)
    
  } else if (hh == 00){
    ampm = "AM"
    hh = as.character("12")
  } else {
    ampm = "AM"
  }
  # Reformat date, below is one option for numerical ID
  # uniqueid = paste0(month, day year, hh, mm, ss)
  
  uniqueid = paste0(month, " ", day, ", ", year, " ", 
                    hh, ":", mm, ":", ss, " ", ampm)
  
  
  
  # Export Results of most recent search to SQLite database
  
  
  
  # Write Query 1 to database in table "Query1" ________________________________
  
  # Prepare annotations to save
  bpn_data = Results$Q1
  
  targets = Results$TARGETS[,1][[1]]
  n = length(targets)
  
  annotations = data.frame(
    x = numeric(n),
    y = numeric(n),
    label = character(n),
    idx = numeric(n)
  )
  
  # For each target, create label for annotations formatted "T1, T2, etc..."
  for (i in 1:n) {
    # Find index j for data
    j = which.min(abs(bpn_data[, mz] - targets[i]))
    targetlabel = ""
    targetlabel = paste0("T", as.character(i))
    # Update annotation x,y coordinates, label and index
    annotations$x[i] <- targets[i]
    annotations$y[i] <- as.numeric(unlist(bpn_data[j, 2])) + 5
    annotations$label[i] <- targetlabel
    annotations$idx[i] <- j
  }
  
  
  n = dim(bpn_data)[1]
  # For each index
  for (i in 1:n){
    
    
    # If an annotation exists, add to target_annotations
    if (isTruthy(annotations$label[i])){
      target_annotations[i] = annotations$label[i]
    } else {
      target_annotations[i] = ""
    }
  }

  rv$completeAnnotations = target_annotations
  
  
  temp_q1 = data.frame(id = rep(uniqueid, n), 
                       mz = Results$Q1$mz, 
                       ab = Results$Q1$ab,
                       labels = target_annotations)
  
  # WRite Query 1
  dbWriteTable(con, "Query1", temp_q1, append= TRUE)
  # dbWriteTable(con, "SearchResults", all_temp_searchResults, append = TRUE)
  
  
  ## Write Query 2 if available ________________________________________________
  if (!is.null(Results$Q2)){
    n = dim(Results$Q2)[1]
    temp_q2 = data.frame(id = rep(uniqueid, n),
                         mz = Results$Q2$mz,
                         ab = Results$Q2$ab)
    
    # Write to database
    dbWriteTable(con, "Query2", temp_q2, append = TRUE)
    
    # # EXample below - how to get Query2 and dispaly an output
    # result2 = dbGetQuery(con, "SELECT * FROM Query2")
    # # print(as_tibble(dbGetQuery(con, "SELECT * FROM Query1")))
    # output$dbGetQueryOutputQ2 <- DT::renderDataTable(
    #   result2
    # )
  }
  
  # Write Search Results _______________________________________________________
  all_temp_searchResults = data.frame()
  
  # Use a loop to go thorugh all search results
  for (i in 1:length(Results$SearchResults)){
    n = nrow(Results$SearchResults[[i]])
    temp_SearchResults = NULL
    # Create dataframe to store result
    temp_SearchResults = data.frame(id = rep(uniqueid, n), 
                                    TargetID = rep(i, n),
                                    Compound = Results$SearchResults[[i]]$Compound,
                                    Class = Results$SearchResults[[i]]$Class,
                                    deltaMZ = Results$SearchResults[[i]]$deltaMZ,
                                    REFMZ = Results$SearchResults[[i]]$REFMZ,
                                    FPIE = Results$SearchResults[[i]]$FPIE,
                                    RevMF = Results$SearchResults[[i]]$RevMF,
                                    IRD = Results$SearchResults[[i]]$IRDiff_30V,
                                    MatchType = Results$SearchResults[[i]]$MatchType
    )
    
    # Append to search result variable
    all_temp_searchResults = rbind(all_temp_searchResults,
                                   temp_SearchResults)
  }
  # Write to database
  dbWriteTable(con, "SearchResults", all_temp_searchResults, append= TRUE)
  
  # # EXample how to access this from the database and display in output
  #   result3 = dbGetQuery(con, "SELECT * FROM SearchResults")
  # # print(as_tibble(dbGetQuery(con, "SELECT * FROM Query1")))
  # output$dbGetQueryOutputQ3 <- DT::renderDataTable(
  #   result3
  # )
  # 
  
  # Write IDs to a table _______________________________________________________
  
  
  # Generate a table for IDs 
  temp_idtable = NULL
  temp_idtable = data.frame(
    id = uniqueid
  )
  
  # Write to database
  dbWriteTable(con, "ID_Table",temp_idtable, append = TRUE )
  
  
  
  # Write targets to table _____________________________________________________
  n = dim(Results$TARGETS)[1]
  # Generate data frame for targets
  temp_targets = data.frame(
    id = rep(uniqueid, n),
    targets = Results$TARGETS[[1]]
  )
  
  dbWriteTable(con, "Targets_Table", temp_targets, append=TRUE)
  
  
  
  # Write metadata to table ____________________________________________________
   temp_meta = data.frame(id = uniqueid,
            filename1 = fileq30print,   
            filename2 = fileq60print,                              
            filename3 = fileq90print,
            entry1 = entry1, entry2 = entry2, entry3 = entry3, entry4 = entry4,
            reflib = RefLibraryPrint, 
            polarity = polarityPrint,
            sourceGas = sourceGasPrint,
            hideTargets = hideTargetsPrint,
            idThreshold = target_min_ab_print,
            mztol = mz_tol_print,
            entry5 = entry5,
            xmin = xmin_dst_print, 
            xmax = xmax_dst_print,
            xmintick = xmintick_dst_print,
            xmaxtick = xmaxtick_dst_print,
            increment = increment_dst_print
  )
         
  print(paste0("TEMP META BEFORE SAVNIG: ", temp_meta))
  # Write to table  
  dbWriteTable(con, "Metadata_Table", temp_meta, append=TRUE)
  
  
  # Refresh the idtable in the database viewer tab _____________________________
  output$idtable <- DT::renderDataTable({
    # req(rv$dbEmpty == FALSE)
    req(rv$dbEmpty == FALSE)
    
    dbGetQuery(con, "Select * from ID_Table")
  },
  selection = 'single'
  )
  
  # Allow database to appear if not already
  # rv$dbEmpty = FALSE
  
  
}