# RefLibSelect dropdown menu for Libraries allows user to select which library
# to use viewer in. 
# Warning: Must use input$RefLibSelect to avoid conflict with RefLibSelect 
# on DST tab

# RefLibSelectDBV <- function(input, rv){

  observeEvent(input$RefLibSelect,{
    # Display progress bar
    withProgress(message = 'Loading ...', {

      # Disable dropdown menu while loading
      disable("RefLibSelect")
      
      # Update variables based on currently selected library
      rv$RefLibrary_rv = readRDS(paste0("Libraries/",input$RefLibSelect))

      isolate({rv_RefLibSelected <<- input$RefLibSelect
      updateSelectInput(session, "RefLibSelect_DST",
                        selected = rv_RefLibSelected)
      
      # Update based on whether selected library is negative
      update_LibraryMode(input$RefLibSelect)
      # Update base peak based on library mode
      basePeakHandler(input, session)
      
      # Identify indices for each column in the library data table (for calling in app)
      rv$LibraryCats = colnames(rv$RefLibrary_rv)
      rv$iCode = which(rv$LibraryCats=="Code")
      rv$iName = which(rv$LibraryCats=="Name")
      rv$iClass = which(rv$LibraryCats=="Class")
      rv$iFormula = which(rv$LibraryCats=="Formula")
      rv$iInChIKey = which(rv$LibraryCats=="InChIKey_gen")
      rv$iPrecursorMZ = which(rv$LibraryCats=="PrecursorMZ_gen")
      rv$iDimerProb = which(rv$LibraryCats=="DimerProb")
      rv$iSmiles = which(rv$LibraryCats=="SMILES")
      rv$iPotentialErrors = which(rv$LibraryCats=="PotentialErrors")
      rv$iMassCaliError = which(rv$LibraryCats=="MassCaliError")
      rv$iPotentialErrorsFM1 = which(rv$LibraryCats=="PotentialErrorsFM1" )
      rv$iExactMass = which(rv$LibraryCats=="AccurateMass_gen")
      rv$iStructure = which(rv$LibraryCats=="Structure_gen")
      rv$iNoiseMetric = which(rv$LibraryCats=="NoiseMetric")
      rv$iBP = which(rv$LibraryCats=="BP")
      rv$iEnergies = which(rv$LibraryCats=="Energies")
      rv$minEnFolder = rv$RefLibrary_rv[1,rv$iEnergies,with=FALSE][[1]][[1]][1]
      
      rv$compoundSelected <- 1
      
      # Enable the dropdown menu
      enable("RefLibSelect")
      })
    })
  })
# }