
# This observeEvent is used to update the number of rows displayed in the side
# bar based on the dropdown menu selection for number of rows to display
library_rows <- function(input, rv){
  
  # Nested observe Event
  observeEvent(input$Library_rows_selected, {
    # Init current library selection
    RefLibrary = rv$RefLibrary_rv
    minEnFolder = rv$minEnFolder
    iPrecursorMZ = rv$iPrecursorMZ
    # Which chemical is selected 
    k = input$Library_rows_selected
    rv$compoundSelected <- k
    # Default to 30V tab
    rv$energySelected <- "Low (30 V)" #minEnFolder; #"+30 V";
    # Reset x-axis max value for displaying each compound's plot
    rv$maxXval <- ceiling(as.numeric(RefLibrary[k,iPrecursorMZ,with=FALSE][[1]]))
  })
}

