# The purpose of this code is to load the library data for the Libraries sidebar
# This is done by loading each column of the data displayed 
# and rendering it into a DT::DataTable with the help of makesubscript 

output$Library <- DT::renderDataTable(
  # Create the DT::datatable
  DT::datatable({
    withProgress(message = 'Loading...', {
         
    # Current library selected
    RefLibrary = rv$RefLibrary_rv
    # index metadata for each library library
    iName <- rv$iName
    iFormula <- rv$iFormula
    iPrecursorMZ <- rv$iPrecursorMZ
    iCode <- rv$iCode
    isyn = rv$iSynonym
    
    # Select columns of ref library to output to be displayed
    # Use iFormulaSub for column specifically with html subscripts
    a = RefLibrary[,c(iName,iFormulaSub,iPrecursorMZ, isyn, iBP),with=FALSE]
    
    # Rename these columns
    colnames(a)[3] = "[M+H]<sup>+</sup>" #rv$mAndH
    colnames(a)[2] = "Formula"
    colnames(a)[5] = "Base Peak"
    
    # Round to 4 decimal places keeping 4 places after including 0's 
    a[,3] = format(round(a[,3],4), nsmall=4)
    a[,5] = format(round(a[,5],4), nsmall=4)
    
    # For each synonym - expand with breaks so each has its own line
    for (i in 1:nrow(a[,4])){
      # Replace each ';' with break '<br/>'
      if (!is.na(a[i,4])){
        a[i,4] = str_replace_all(a[i,4], pattern = ";", replacement = ";<br/>")
      } else {
        # Otherwise put NA
        a[i,4] = NA
      }
    }
      
  })
  return(a)
  }), # end datatable
  
  # datatable options
  server = FALSE, escape=FALSE,
  selection=list(mode='single', selected=1),
  options = list(#bPaginate = TRUE,
                 dom = 'lfpt',
                 scrollY=TRUE,
                 autoWidth = TRUE,
                 columnDefs = list(list(width = '200px', targets = c(1,4)),
                                   list(width = '75px', targets = c(3,5)),
                                   list(width = '120px', targets = c(2)))
                 
                 ),
  filter = list(position = "top", clear = FALSE),
  
  
) 

