
# This program creates a toggle which Shows/hides certain elements of DBV 
# when in interactive vs expanded view

toggle_DBV <- function(input){
  observeEvent(input$toggle_DBV, {
    req(input$toggle_DBV)
    if(input$toggle_DBV == "Interactive"){
      # Show messsages at top of page (messagerow)
      show("MessageRow_DBV")
      # Show side panel for searching
      show("side-panel-DBV")
      # Main panel contains table and interactive figure
      show("UI_DBV")
      show("LibraryPlot")
      show("peakListUI_DBV")
      show("LibraryPlotsUI")
      show("interactivePeakList_DBV")
      hide("structurePlotter_Reporting")
      show("structurePlotter_plot")
      # Hide expanded view
      hide("expanded-panel")
  
    } else {
      # Show expanded view here
      show("expanded-panel")
      show("structurePlotter_Reporting")
      hide("structurePlotter_plot")
      hide("peakListUI_DBV")
      hide("interactivePeakList_DBV")
      hide("MessageRow_DBV")
      hide("side-panel-DBV")
      hide("UI_DBV")
      hide("LibraryPlotsUI")
      hide("LibraryPlot")

      

    }
  })
}