
# This program creates the chemical structure to be displayed for each compound
output$structurePlotter_plot <- renderPlot({
  RefLibrary = rv$RefLibrary_rv
  iStructure = rv$iStructure
  
  
  j = rv$compoundSelected;
  struc_data =  RefLibrary[j,iStructure,with=FALSE][[1]][[1]]
  
  temp = strsplit(struc_data[4],' ')[[1]]
  temp = temp[temp!=""]
  natoms = as.numeric(temp[1])
  nconnections = as.numeric(temp[2])
  s1 = 5;
  s2 = s1+natoms-1
  atomInfo = seq(s1,s2)
  
  s3 = s2+1
  s4 = s2+nconnections
  connInfo = seq(s3,s4)
  
  DeuteratedInfoLine = grep("ISO",struc_data)
  if(length(DeuteratedInfoLine)>0){
    DeuteratedInfo = strsplit(struc_data[DeuteratedInfoLine]," ")[[1]]
    spaces = which(DeuteratedInfo=="")
    DeuteratedInfo = DeuteratedInfo[-spaces]
    DeuteratedSet = DeuteratedInfo[seq(4,length(DeuteratedInfo),2)]
  } else {
    DeuteratedSet = NULL
  }
  
  x = numeric(natoms)
  y = numeric(natoms)
  c = character(natoms)
  
  p = numeric(nconnections)
  q = numeric(nconnections)
  t = character(nconnections)
  
  
  
  for(i in 1:natoms){
    temp2 = strsplit(struc_data[atomInfo[i]]," ")[[1]]
    spaces = which(temp2=="");
    temp2 = temp2[-spaces]
    x[i] = as.numeric(temp2[1])
    y[i] = as.numeric(temp2[2])
    if(i %in% DeuteratedSet){
      if(temp2[4]=="H"){
        c[i] = "D"
      }
    } else {
      c[i] = temp2[4]  
    }
  }
  
  for(i in 1:nconnections){
    temp3 = strsplit(struc_data[connInfo[i]]," ")[[1]]
    spaces = which(temp3=="");
    temp3 = temp3[-spaces]
    p[i] = as.numeric(temp3[1])
    q[i] = as.numeric(temp3[2])
    t[i] = temp3[3]
  }
  
  
  minX = min(x); maxX = max(x); midX = 0.5*(minX+maxX)
  minY = min(y); maxY = max(y); midY = 0.5*(minY+maxY)
  
  x = x-midX;
  y = y-midY;
  
  plot(x,y,
       xlim=c(min(x),max(x)),
       ylim=c(min(y),max(y)),
       axes=FALSE,
       cex=0.1,
       pch=18,
       col = "white",
       xlab="",ylab="")
  
  offset=0.006*(maxX-minX)
  offset3 = 1.1*offset
  
  for(i in 1:nconnections){
    if(t[i]=="1"){
      segments(x[p[i]],y[p[i]],x[q[i]],y[q[i]])
    } else if (t[i] =="2"){
      if(x[p[i]] == x[q[i]]){ # vertical
        segments((x[p[i]]-offset3),y[p[i]],(x[q[i]]-offset3),y[q[i]],col="blue")
        segments((x[p[i]]+offset3),y[p[i]],(x[q[i]]+offset3),y[q[i]],col="blue")
      } else {
        segments(x[p[i]],(y[p[i]]-offset),x[q[i]],(y[q[i]]-offset),col="blue")
        segments(x[p[i]],(y[p[i]]+offset),x[q[i]],(y[q[i]]+offset),col="blue")
      }
    } else if (t[i] == "3"){
      if(x[p[i]] == x[q[i]]){
        segments((x[p[i]]-offset3),y[p[i]],(x[q[i]]-offset3),y[q[i]],col="red")
        segments(x[p[i]],y[p[i]],x[q[i]],y[q[i]],col="red")
        segments((x[p[i]]+offset3),y[p[i]],(x[q[i]]+offset3),y[q[i]],col="red")
      } else {
        segments(x[p[i]],(y[p[i]]-offset3),x[q[i]],(y[q[i]]-offset3),col="red")
        segments(x[p[i]],y[p[i]],x[q[i]],y[q[i]],col="red")
        segments(x[p[i]],(y[p[i]]+offset3),x[q[i]],(y[q[i]]+offset3),col="red")
      }
    }
    
  }
  nonC = which(c!="C")
  matplot(x[nonC],y[nonC],col = "white",pch=15,
          cex = 1.5,add=TRUE)
  
  text(x[nonC],y[nonC],c[nonC],cex=0.7)
  
  
})

output$structurePlotter_Reporting <- renderPlot({
  RefLibrary = rv$RefLibrary_rv
  iStructure = rv$iStructure
  
  
  j = rv$compoundSelected;
  struc_data =  RefLibrary[j,iStructure,with=FALSE][[1]][[1]]
  
  temp = strsplit(struc_data[4],' ')[[1]]
  temp = temp[temp!=""]
  natoms = as.numeric(temp[1])
  nconnections = as.numeric(temp[2])
  s1 = 5;
  s2 = s1+natoms-1
  atomInfo = seq(s1,s2)
  
  s3 = s2+1
  s4 = s2+nconnections
  connInfo = seq(s3,s4)
  
  x = numeric(natoms)
  y = numeric(natoms)
  c = character(natoms)
  
  p = numeric(nconnections)
  q = numeric(nconnections)
  t = character(nconnections)
  
  for(i in 1:natoms){
    temp2 = strsplit(struc_data[atomInfo[i]]," ")[[1]]
    spaces = which(temp2=="");
    temp2 = temp2[-spaces]
    x[i] = as.numeric(temp2[1])
    y[i] = as.numeric(temp2[2])
    c[i] = temp2[4]
  }
  
  for(i in 1:nconnections){
    temp3 = strsplit(struc_data[connInfo[i]]," ")[[1]]
    spaces = which(temp3=="");
    temp3 = temp3[-spaces]
    p[i] = as.numeric(temp3[1])
    q[i] = as.numeric(temp3[2])
    t[i] = temp3[3]
  }
  
  
  minX = min(x); maxX = max(x); midX = 0.5*(minX+maxX)
  minY = min(y); maxY = max(y); midY = 0.5*(minY+maxY)
  
  x = x-midX;
  y = y-midY;
  
  plot(x,y,
       xlim=c(min(x),max(x)),
       ylim=c(min(y),max(y)),
       axes=FALSE,
       cex=0.1,
       pch=18,
       col = "white",
       xlab="",ylab="")
  
  offset=0.006*(maxX-minX)
  offset3 = 1.1*offset
  
  for(i in 1:nconnections){
    if(t[i]=="1"){
      segments(x[p[i]],y[p[i]],x[q[i]],y[q[i]])
    } else if (t[i] =="2"){
      if(x[p[i]] == x[q[i]]){ # vertical
        segments((x[p[i]]-offset3),y[p[i]],(x[q[i]]-offset3),y[q[i]],col="blue")
        segments((x[p[i]]+offset3),y[p[i]],(x[q[i]]+offset3),y[q[i]],col="blue")
      } else {
        segments(x[p[i]],(y[p[i]]-offset),x[q[i]],(y[q[i]]-offset),col="blue")
        segments(x[p[i]],(y[p[i]]+offset),x[q[i]],(y[q[i]]+offset),col="blue")
      }
    } else if (t[i] == "3"){
      if(x[p[i]] == x[q[i]]){
        segments((x[p[i]]-offset3),y[p[i]],(x[q[i]]-offset3),y[q[i]],col="red")
        segments(x[p[i]],y[p[i]],x[q[i]],y[q[i]],col="red")
        segments((x[p[i]]+offset3),y[p[i]],(x[q[i]]+offset3),y[q[i]],col="red")
      } else {
        segments(x[p[i]],(y[p[i]]-offset3),x[q[i]],(y[q[i]]-offset3),col="red")
        segments(x[p[i]],y[p[i]],x[q[i]],y[q[i]],col="red")
        segments(x[p[i]],(y[p[i]]+offset3),x[q[i]],(y[q[i]]+offset3),col="red")
      }
    }
    
  }
  nonC = which(c!="C")
  matplot(x[nonC],y[nonC],col = "white",pch=15,
          cex = 1.5,add=TRUE)
  
  text(x[nonC],y[nonC],c[nonC],cex=0.7)
  
  
})