# The purpose of  this function is to create the main panel table for 
# library data to be displayed for the currently selected compound. 

# This code also makes use of a Helper function at the bottom that 
# sanitizes the text function to enable for breaks, subscripts, displaying of 
# greek symbol, and handling of href 

output$LibraryData <- renderTable({
  # Get indices for compound of interest for current selection
  RefLibrary = rv$RefLibrary_rv
  iCode = rv$iCode
  iName = rv$iName
  iClass = rv$iClass
  iFormula = rv$iFormula
  iExactMass = rv$iExactMass
  iInChIKey = rv$iInChIKey
  iDimerProb = rv$iDimerProb
  iPotentialerrors = rv$iPotentialErrors
  iMassCaliError = rv$iMassCaliError
  iPotentialErrorsFM1 = rv$iPotentialErrorsFM1
  iNoiseMetric = rv$iNoiseMetric
  iSynonyms = rv$iSynonym
  k = rv$compoundSelected
  j = rv$energySelected
  i = which(unlist(RefLibrary[k, Energies]) == j)
  
  # Get current parameters 
  code      = RefLibrary[k, iCode, with = FALSE][[1]]
  name      = RefLibrary[k, iName, with = FALSE][[1]]
  class = RefLibrary[k, iClass, with = FALSE][[1]]
  # Use subscripted html formula instead of iFormula
  formula   = RefLibrary[k, iFormulaSub, with = FALSE][[1]]
  emass     = RefLibrary[k, iExactMass, with = FALSE][[1]]
  inchi     = RefLibrary[k, iInChIKey, with = FALSE][[1]]
  dimerProb = RefLibrary[k, iDimerProb, with = FALSE][[1]]
  potError  = RefLibrary[k, iPotentialErrors, with = FALSE][[1]]
  MCerror   = RefLibrary[k, iMassCaliError, with = FALSE][[1]]
  FM1error   = RefLibrary[k, iPotentialErrorsFM1, with = FALSE][[1]]
  NoiseRatio = RefLibrary[k, iNoiseMetric, with = FALSE][[1]][[1]][i]
  synonyms = RefLibrary[k, iSynonym, with = FALSE][[1]]
  protmol = RefLibrary[k, iPrecursorMZ, with = FALSE][[1]]
  basepeak = RefLibrary[k, iBP, with = FALSE][[1]]
  polarity = RefLibrary[k, iPolarity, with = FALSE][[1]]
  sourceGas = RefLibrary[k, iSourceGas, with = FALSE][[1]]
  
  # Get synonyms and make new line for each synonym
  if (is.na(synonyms)){
    synonyms = NA
  } else {
    synonyms = str_replace_all(synonyms, pattern = "[;]", replacement = ";<br>")
  }
  
  ## Other Stuff ###############################################################
  if (dimerProb > 0.90) {
    commentMessage = "Possible dimer"
  } else {
    commentMessage = "None"
  }
  
  contributor_code = strsplit(code, "")[[1]][1]
  if (contributor_code == "V") {
    contributor = "Virginia Dept. of Forensics Science"
  } else if (contributor_code == "a") {
    contributor = "For Manuscript - NIST"
  } else {
    contributor = "NIST"
  }
  
  errorMessage = paste("BP (30 V) mz error: ", round(-as.numeric(MCerror), 4), sep =
                         "")
  
  if (FM1error > 0) {
    FMerrorMessage1 = "Possible fragmentation inconsistency."
  } else {
    FMerrorMessage1 = "None"
  }
  
  ## DEV MODE ## 
  if (dev_mode == 1) {
    Message = as.data.frame(array(0, dim = c(10, 1)))
    
    rownames(Message) <- c(
      "Code:",
      "Name:",
      "Formula:",
      "Exact Mass (Da):",
      "InChIKey:",
      "Contributor:",
      "Comment:",
      "Dev. Comment 1 (BP):",
      "Dev. Comment 2 (FC):",
      "Dev. Comment 3 (NR):"
    )
    
    Message[1, 1] = code
    Message[2, 1] = name
    Message[3, 1] = formula
    Message[4, 1] = round(as.numeric(emass), 4)
    Message[5, 1] = paste(
      "<a href='http://www.ncbi.nlm.nih.gov/sites/entrez?cmd=search&db=pccompound&term=\"",
      inchi,
      "\"[InChIKey]' target='_blank'>",
      inchi,
      "</a>"
    )
    Message[6, 1] = contributor
    Message[7, 1] = commentMessage
    Message[8, 1] = errorMessage
    Message[9, 1] = FMerrorMessage1
    Message[10, 1] = round(as.numeric(NoiseRatio), 3)
    
    
    
    # If not in dev mode #######################################################
  } else {
    # Initialize data table
    Message = as.data.frame(array(0, dim = c(13, 1)))
    
    rownames(Message) <- c(
      "Library:",
      "Polarity: ", 
      "Source Gas: ",
      "",
      "Name:",
      "Class:",
      "Formula:",
      "Exact Mass (Da):",
      rv$mAndHLib, 
      "30 V Base Peak (<em>m/z</em>): ",
      "InChIKey:",
      "Contributor:",
      "Synonyms:"
    )
    
    # Input fields for data table displayed
    Message[1, 1] = input$RefLibSelect
    Message[2,1] = polarity
    Message[3,1] = sourceGas
    Message[4,1] = ""
    Message[5, 1] = name
    Message[6, 1] = class
    Message[7, 1] = formula
    Message[8, 1] = format(round(as.numeric(emass) + 0.00001, 4), nsmall=4)
    Message[9,1] = format(round(as.numeric(protmol) + 0.00001, 4), nsmall=4)
    Message[10,1] = format(round(as.numeric(basepeak) + 0.00001, 4), nsmall=4)
    if(input$toggle_DBV == "Interactive"){
      
      Message[11, 1] = paste(
        "<a href='http://www.ncbi.nlm.nih.gov/sites/entrez?cmd=search&db=pccompound&term=\"",
        inchi,
        "\"[InChIKey]' target='_blank'>",
        inchi,
        "</a>")
    } else {
      Message[11, 1] = inchi
    }
    Message[12, 1] = contributor
    Message[13, 1] = synonyms
    
  }

  # Return table
  # enable("RefLibSelect")
  
  return(Message)
  
  
}, rownames = TRUE, 
  colnames = FALSE, 
  sanitize.text.function = function(x) sapply(x,f),
  
)


# Use this function for santizing text in renderTable output
f <- function(x){

  # If string doesn't contain a hyperlink, sanitize for special characters (greek symbols)
  if (grepl("href", x, fixed=TRUE)){
    x
    
  } else if (grepl("<sub>", x, fixed=TRUE)){
    x
  } else if (grepl("<sup>", x, fixed = TRUE)){
    x
  } else if (grepl("<em>", x, fixed = TRUE)){
    x
  } else {
    xs <- strsplit(as.character(x), "")[[1]]
    x <- paste0(sprintf("&#%d;", sapply(xs, utf8ToInt)), collapse="")
    if (grepl("&#60;&#98;&#114;&#62;", x, fixed = TRUE)){
      x = str_replace_all(x, pattern = "&#60;&#98;&#114;&#62;", replacement = "<br>")
    }
    x
    #   # Pipe html of url to extract attribute href
    # } else {x %>% read_html(x) %>% html_nodes("a") %>%html_attr('href')}
  }
}
