
# This program has two outputs.
# The first output creates the UI for the peak list in interactive view
# The second output creates the peak list itself for each tab of the peaklist UI


## peakListUI_DBV ##############################################################
# Create the peak list UI
output$peakListUI_DBV <- renderUI({

  # Initialize the tabs
  choices = c("Top 10", "All Peaks")
  # For each tab create the tabSetPanel
  do.call(tabsetPanel, c(id='pltab_DBV', lapply(1:length(choices), function(i){
    tabPanel(title=choices[i])
    
  })))
})

## interactivePeakList_DBV #####################################################
# Create the peak list for currently selected tab out of the UI
output$interactivePeakList_DBV <- renderDataTable({
  # # Init RefLibrary and compound selected currently

  k = rv$energySelected;
  k = str_extract(k, "[0-9]+ V")
  k = paste0("+",k)
  
  bpn_data = format_peakList(bpn_data, k)

  # Sort data in decreasing order
  return(bpn_data)
  
},
selection = 'single',      # Must come first
escape = FALSE,            # Allow HTML such as italics <em> </em>
rownames = FALSE,
options = list(dom  = 'ltp',
               # autowidth=TRUE,
               lengthMenu = list(c(10, 30, -1), c('10', '30', 'All')),
               
               rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}"),
               columnDefs = list(list(width='30px', targets = c(0,1)))
               
)
)