# The purpose of this program is to create the library plots and the UI tabs 
# (30, 60, and 90V tabs) for the interactive view 


## LibraryPlotsUI ##############################################################
# Creates UI element tabs for 30, 60, 90 tabs in interactive view
output$LibraryPlotsUI <- renderUI({
  RefLibrary = rv$RefLibrary_rv
  j = rv$compoundSelected;
  # Each compound has a number of spectra 
  # ie. 30V = 1.
  # 30, 60, 90 = 3 spectra
  NumSpectra = unlist(RefLibrary[j,NumSpectra]);
  QueryType = c("Low (30 V)", "Mid (60 V)", "High (90 V)")
  QueryType = QueryType[1:NumSpectra]
  
  
  # Create a tab for each of the number of spectra and display energies
  do.call(tabsetPanel, c(id='plottab',lapply(1:NumSpectra, function(i) {
    tabPanel(title=QueryType[i])
  
  })))
})

## LibraryPlot #################################################################
# Create the plots within each tab
output$LibraryPlot <- renderPlotly({
  RefLibrary = rv$RefLibrary_rv
  # Current compound and current voltage selected
  j = rv$compoundSelected;
  # k = '+30 V' for example
  k = rv$energySelected;
  k = str_extract(k, "[0-9]+ V")
  # i = index 1 = +30V, 2 = +60V etc
  i = which(unlist(RefLibrary[j,Energies])==paste0("+",k));
  # Get actual name string of compound
  compoundname = RefLibrary[j, rv$iName, with = FALSE][[1]]
  
  #asm_spec2dt_ref(unlist(RefLibrary[j,PeakLists])[[i]],pmass)
  data = as.data.table(RefLibrary[j,PeakLists][[1]][i]); 
  bpn_data = asm_bpNormalizer(data, "HiRes", 0, 0)
  l = length(RefLibrary[j,RefinedAnnotations][[1]][i][[1]])
  
  
  # Get all axis limits for compound selected ##################################
  QueryType = c("Low (30 V)", "Mid (60 V)", "High (90 V)")
  n = length(QueryType);
  axisLimits = data.frame(xmin = numeric(n), xmax = numeric(n),
                          ymin = numeric(n), ymax = numeric(n))
  # Use helper function to get axis limits for each query spectra
  axisLimits = getAxisLimits(  
    asm_bpNormalizer(
      as.data.table(RefLibrary[j,PeakLists][[1]][1]), "HiRes", 0, 0
      )
    , axisLimits, 1)
  axisLimits = getAxisLimits(  
    asm_bpNormalizer(as.data.table(RefLibrary[j,PeakLists][[1]][2]), "HiRes", 0, 0
                     )
    , axisLimits, 2)
  axisLimits = getAxisLimits(  
    asm_bpNormalizer(as.data.table(RefLibrary[j,PeakLists][[1]][3]), "HiRes", 0, 0
                     )
    , axisLimits, 3)

  
  # Get overall xmin and xmax by ordering the dataframe axisLimits
  xminall = ceiling(axisLimits[order(axisLimits$xmin),1][1])
  xmaxall = ceiling(axisLimits[order(-axisLimits$xmax),2][1])
  
  # Do calculations to find nearest mod 50 from axis limits
  t = 50%%xminall
  if (xminall < 50){
    xmintick = t + xminall
  } else {
    xmintick = t
  }

  xmintick = floor(xminall/50)*50;  # added by arun 09/15/2021 - replaces previous if conditional
  
  t = xmaxall%%50
  xmaxtick = xmaxall - t + 50

  xmaxtick = ceiling(xmaxall/50)*50; # added by arun 09/15/2021 - replaces previous 2 lines of code

  
  # Save as reactive value for DST
  rv$xmin_dbv = xminall
  rv$xmax_dbv = xmaxall
  rv$xmintick_dbv = xmintick
  rv$xmaxtick_dbv = xmaxtick
  
  
  # Annotations when hovering over peaks #######################################
  annotations = character(l)
  for(m in 1:l){
    o = length(RefLibrary[j,RefinedAnnotations][[1]][i][[1]][m][[1]])
    temp_text = NULL
    for (p in 1:o){
      temp_text = paste(temp_text,RefLibrary[j,RefinedAnnotations][[1]][i][[1]][m][[1]][p],"\n")
    }
    annotations[m] = temp_text
  }
  
  col = character(l)
  for(m in 1:l){
    if(annotations[m]=="  \n"){
      col[m] = "grey"
    } else {
      col[m] = "blue"
    }
  }
  
  # Create plot ###############################################################
  
  bpn_data = cbind(bpn_data,annotations)
  
  # Create actual plots
  # https://felixfan.github.io/ggplot2-remove-grid-background-margin/
  # ggplotly to allow for hovering and annotation functionality (order matters)
  # aes - aesthetics when hovering over peaks
  p <- ggplot(bpn_data,
              aes(x=mz, ymax=ab, ymin = 0, text=paste0("m/z: ",round(mz,4),"\nrel. int.: ",round(ab,1), "\n\nPossible Formula(s):\n", annotations)))
  # Color of each peak
  p <- p + geom_linerange(color=col)
  # x and y axis titles
  p <- p + labs(title="", #paste0(k, " ", compoundname),
                x="m/z",
                y="Relative Intensity (%)")
  # Customize plot
  p <- p + theme(panel.grid.major = element_blank(), 
                 panel.grid.minor = element_blank(),
                 panel.background = element_blank(), 
                 axis.line = element_line(colour = "black"),
                 axis.title.y = element_text(size = 10),
                 axis.title.x = element_text(size=10, face="italic"))
  p <- p + scale_x_continuous(limits = c(rv$xmin_dbv, rv$xmax_dbv), 
                              breaks= seq(rv$xmintick_dbv, rv$xmaxtick_dbv,50))
  
  
  # tooltip is for annotation display when hovering
  ggplotly(p,tooltip=c('text'))
})
