# This program creates the expanded view peak lists for the 30, 60, and 90V 
# spectrums in the Libraries tab. There are three outputs included, one for each
# of the peak lists. There is also a helper function at the bottom which returns
# the peak list data (bpn_data) for each of the spectra depending on which tab
# was last selected in the interactive view

## expandedPeakList1_DBV, 2, and 3 ############################################
# Return the peak list after calling helper function with options and sanitizing
output$expandedPeakList1_DBV <- renderDataTable({
  # bpn_data = getCurrCompounds("+30 V")
  bpn_data = format_peakList(NULL, "+30 V")
  
  return(bpn_data)
  
},
selection = 'single',

escape = FALSE,            # Allow HTML such as italics <em> </em>
rownames = FALSE,
options = list(dom  = 'ltp',
               autowidth=TRUE,
               lengthMenu = list(c(10, 30, -1), c('10', '30', 'All')),
               rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}")
)
)

# Repeat for peak list for 60 and 90V spectra
output$expandedPeakList2_DBV <- renderDataTable({
  bpn_data = format_peakList(NULL, "+60 V")
  return(bpn_data)
}, 
selection = 'single',

escape = FALSE,            # Allow HTML such as italics <em> </em>
rownames = FALSE,
options = list(dom  = 'ltp',
               autowidth=TRUE,
               lengthMenu = list(c(10, 30, -1), c('10', '30', 'All')),
               rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}")
)
)


output$expandedPeakList3_DBV <- renderDataTable({
  bpn_data = format_peakList(NULL, "+90 V")
  return(bpn_data)
},  
selection = 'single',

escape = FALSE,            # Allow HTML such as italics <em> </em>
rownames = FALSE,
options = list(dom  = 'ltp',
               autowidth=TRUE,
               lengthMenu = list(c(10, 30, -1), c('10', '30', 'All')),
               rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}")
)
)

## getCurrCompounds ###########################################################
# This helper function returns the bpn_data for the currently selected compound
# which is the peak list, edited based on the currently selected tab
getCurrCompounds <- function(k){
  
}
