# This program creates the 3 plots in expanded view for the currently selected
# compound in the Libraries tab. A helper function is included at the bottom of
# this program to eliminate some redundancy.
# There are three outputs, one for each of the plots in expanded view


## allLibraryPlots1, 2, and 3 #################################################
# For all 3 spectra create expanded view plots 
output$allLibraryPlots1 <- renderPlot({
  # Init currently selected compound
  RefLibrary = rv$RefLibrary_rv
  j = rv$compoundSelected;
  # Get compound name for plot title
  compoundname = RefLibrary[j, rv$iName, with = FALSE][[1]]
  # Create data for current selection and normalize
  data = as.data.table(RefLibrary[j,PeakLists][[1]][1]); 
  bpn_data = asm_bpNormalizer(data, "HiRes", 0, 0)
  # Use helper function for plotting
  create_ggplot_dbv(bpn_data, "30 V", compoundname)
})


# Repeat for 60 and 90V query spectra
output$allLibraryPlots2 <- renderPlot({
  RefLibrary = rv$RefLibrary_rv
  j = rv$compoundSelected;
  compoundname = RefLibrary[j, rv$iName, with = FALSE][[1]]
  data = as.data.table(RefLibrary[j,PeakLists][[1]][2]); 
  bpn_data = asm_bpNormalizer(data, "HiRes", 0, 0)
  create_ggplot_dbv(bpn_data, "60 V", compoundname)
})

output$allLibraryPlots3 <- renderPlot({
  RefLibrary = rv$RefLibrary_rv
  j = rv$compoundSelected;
  compoundname = RefLibrary[j, rv$iName, with = FALSE][[1]]
  data = as.data.table(RefLibrary[j,PeakLists][[1]][3]); 
  bpn_data = asm_bpNormalizer(data, "HiRes", 0, 0)
  create_ggplot_dbv(bpn_data, "90 V", compoundname)
})

## create_ggplot_dbv ###########################################################
# This function creates each individual plot in expanded view of DBV
create_ggplot_dbv <- function(data, tit, name){
  ggplot(data, aes(x = mz, xend=mz, y=0, yend = ab)) +
    labs(title=paste0(tit, " ", name),
         x="*m/z*",
         y="Relative Intensity (%)") +
    theme(axis.title.x = ggtext::element_markdown(size = 14), 
          axis.title.y = ggtext::element_markdown(size=14),
          plot.title = element_text(size=20),#, hjust=0.5),
          panel.grid.major = element_blank(),panel.grid.minor = element_blank(),
          panel.background = element_blank(),
          axis.line = element_line(color="black")) +
    geom_segment() + 
    scale_x_continuous(limits = c(rv$xmin_dbv, rv$xmax_dbv), 
                       breaks= seq(rv$xmintick_dbv, rv$xmaxtick_dbv,50))
}