


# Use rv$currtrigger = 1 to refererence 'Update Search' on Settings panel
trigger_button <- eventReactive(input$DartSearch,{
  
  rv$currtrigger = 1                # Using trigger_button() 1 of 2
  triggerButtonRun()                # Call helper function
})

# Use rv$currtrigger = 2 to reference 'Update Search' on Settings panel
trigger_button2 <- eventReactive(input$DartSearchAdv, {
  
  rv$currtrigger = 2                # Using trigger_button() 2 of 2
  # lowres(input, rv)                 # Necessary dependency
  triggerButtonRun()                # Call helper function
})

triggerButtonRun <- function(){

  # Init display resets main panel elements, warnings, & previous searches
  # Init display only works if 30 V query is provided. 
  initDisplay()       
  
  # Get all relevant settings 
  searchParams = getSearchParams()

  # Get files
  results = fileConfigDisplay()       # Configure mainPanel by file uploads
  Query1 = unpackResults(1, results)  # Unpack results while ignoring nulls
  Query2 = unpackResults(2, results) 
  Query3 = unpackResults(3, results) 
  
  allTargets <<- NULL
  Results <<- NULL
  showidx <<- NULL
  withProgress(message = 'Analysis Progress', value = 0, {
    Results <<- asm_ILSA(Query1, Query2, Query3, 
                       searchParams[[1]], searchParams[[2]], searchParams[[3]],
                       searchParams[[4]], noiseThreshold, searchParams[[6]])
  })
  
  if (is.null(Results$Q2) && !is.null(Results$Q3)){
    rv$case_A = 1
  }
  
  rv$targets_mz = Results$TARGETS[,1]
  rv$targets_in = Results$TARGETS[,2]
  rv$numTargets = min(MAX_TARGETS,length(Results$TARGETS[[1]]))
  rv$fileq30 = input$q30$name
  rv$fileq60 = input$q60$name
  rv$fileq90 = input$q90$name
  target_min_ab_print <<- as.numeric(rv$target_min_ab)
  # Update file inputs
  fileq30print <<- rv$fileq30 
  fileq60print <<- rv$fileq60 
  fileq90print <<- rv$fileq90 
  
  if (is.null(input$q30$name) || !isTruthy(rv$datapathq30)){
    fileq30print <<- "No file selected" 
  }
  if (is.null(input$q60$name) || !isTruthy(rv$datapathq60)){
    fileq60print <<- "No file selected" 
  }
  if (is.null(input$q90$name) || !isTruthy(rv$datapathq90)){
    fileq90print <<- "No file selected" 
  }

  
 
  
  templst = Results$SearchResults
  newlst.list = NULL
  for (i in 1:length(Results$SearchResults)){

      mylist = templst[[i]]
      newlst.list[[i]] = mylist[, c(1, 2, 3, 5, 9, 17, 18)]
      # cat("Result ", i, "\n")
      # print(mylist[,c(1, 2, 3,5,9, 17, 18)])
      # cat("\n")

  }
  
  # cat("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n")   
  
  allTargets <<- newlst.list
  

  #NORMALIZE THE DATA HERE #####################################################

  sst_normalize <- function(x,maxxi){
    100*(x/maxxi)
  }
  
  maxxi = max(Results$Q1[,2])
  Results$Q1[,2] = lapply(Results$Q1[,2], sst_normalize, maxxi)
  
  if(is.null(Results$Q2)==FALSE){
    maxxi = max(Results$Q2[,2])
    Results$Q2[,2] = lapply(Results$Q2[,2], sst_normalize, maxxi)  
  }
  
  if(is.null(Results$Q3)==FALSE){
    maxxi = max(Results$Q3[,2])
    Results$Q3[,2] = lapply(Results$Q3[,2], sst_normalize, maxxi)  
  }
  
  Results <<- Results
  
  ##################################################################
  

  cat(paste0("\n\nsidebar_Trigger_Button.R: Line 113: ",rv$numTargets,"\n\n"))
  # Get a list of indices for which targets in allTargets.list to show
  showidx <<- get_showidx(rv$hideTargets, rv$numTargets, NULL)

  
  # Update the UI for interactive view targets
  showtargets_UI(showidx, length(showidx))
  # Populate interactive target
  showidx <<- showidx
  showtargets_int(allTargets, mz_tol_print, showidx)
  
  
  
  
  
  
  
  # Init a dataframe to store axis limits HARD CODED 
  QueryType = c("Low (30 V)", "Mid (60 V)", "High (90 V)")
  n = length(QueryType);
  axisLimits = data.frame(xmin = numeric(n), xmax = numeric(n),
                          ymin = numeric(n), ymax = numeric(n))
  # Use helper function to get axis limits for each query spectra
  if (NumSpectra == 1){
    axisLimits = getAxisLimits(Results$Q1, axisLimits, 1)
    
  }
  if (NumSpectra == 2){
    if (rv$case_A == 1){
      axisLimits = getAxisLimits(Results$Q1, axisLimits, 1)
      axisLimits = getAxisLimits(Results$Q3, axisLimits, 2)
    } else {
      axisLimits = getAxisLimits(Results$Q1, axisLimits, 1)
      axisLimits = getAxisLimits(Results$Q2, axisLimits, 2)
    }
  }
  if (NumSpectra == 3){
    axisLimits = getAxisLimits(Results$Q1, axisLimits, 1)
    axisLimits = getAxisLimits(Results$Q2, axisLimits, 2)
    axisLimits = getAxisLimits(Results$Q3, axisLimits, 3)
  }
  
  
  # Get overall xmin and xmax by ordering the dataframe axisLimits
  xminall = ceiling(axisLimits[order(axisLimits$xmin),1][1])
  xmaxall = ceiling(axisLimits[order(-axisLimits$xmax),2][1])
  
  # Do calculations to find nearest mod 50 from axis limits
  t = 50%%xminall
  if (xminall < 50){
    xmintick = t + xminall
  } else {
    xmintick = t
  }
  
  xmintick = floor(xminall/50)*50;  # added by arun 09/15/2021 - replaces previous if conditional
  
  t = xmaxall%%50
  xmaxtick = xmaxall - t + 50
  
  xmaxtick = ceiling(xmaxall/50)*50; # added by arun 09/15/2021 - replaces previous 2 lines of code
  
  if (is.na(xmintick)){
    xmintick = 0
  }
  
  
  # Save as reactive value for DST
  rv$xmin_dst = xminall
  rv$xmax_dst = xmaxall
  rv$xmintick_dst = xmintick
  rv$xmaxtick_dst = xmaxtick
  
  if (rv$xmaxtick_dst > 700){
    rv$increment_dst = 100
  }
  
  
  xmin_dst_print <<- rv$xmin_dst
  xmax_dst_print <<- rv$xmax_dst
  xmintick_dst_print <<- rv$xmintick_dst
  xmaxtick_dst_print <<- rv$xmaxtick_dst
  increment_dst_print <<- rv$increment_dst
  
  # Add entry to database
  # addToDB_SQL()
  
  return(TRUE)
}


