
## sidebar_TriggerButtonHelpers.R



## initDisplay #################################################################
## Initialize / reset the mainpanel before running a search
initDisplay <- function(){
  hide("ErrorSameFilec0")
  hide("ErrorSameFilec1")
  hide("ErrorSameFilec2")
  hide("ErrorSameFilec3")  
  show("ErrorNoFile")
  show("expanded_plot_row")
  
  req(isTruthy(rv$datapathq30))
  rv$case_A = 0
  
  # If there is a valid file upload
  show("mainPanel_DST")
  show("pl")
  hide("ErrorNoFile")
  
  # Before continuing, clear all outputs from previous search queries
  for (i in seq(1, rv$numTargets*2, 2)){
    local({
      i <- i
      id <- paste0("dt", i)
      idplus <- paste0("dt", i+1)
      
      output[[id]] <- renderUI(NULL)
      output[[idplus]] <- DT::renderDataTable(NULL)
    })
    
  }
  
}


getSearchParams <- function(){
  
  # Init important variables
  RefLibrary = rv$RefLibrary_rv
  iPrecursorMZ = rv$iPrecursorMZ
  iBP = rv$iBP
  
  ## Update rv fields
  # rv$search_type = input$searchType
  rv$mz_tol = input$epsilon_0
  # rv$target_type = input$target_type
  
  # # Update rv  based on user inputs
  # if(rv$search_type=="ma"){
  #   # converts to a fraction for processing purposes
  #   rv$target_min_ab = input$target_min_ab/100; 
  # } else if (rv$search_type == "pc"){
  #   rv$target_min_ab = 1; 
  # }  
  
  ## Update expanded view variables
  # target_type_print <<- rv$target_type
  # target_type_print <<- rv$target_type
  target_min_ab_print <<- rv$target_min_ab
  RefLibraryPrint <<- input$RefLibSelect_DST
  iPrecursorMZPrint <<- iPrecursorMZ
  iBPPrint <<- iBP
  bpN_Query1Print <<- rv$bpN_Query1
  numTargetsPrint <<- rv$numTargets
  hideTargetsPrint <<- rv$hideTargets
  mz_tol_print <<- rv$mz_tol
  mAndHPrint <<- rv$mAndH
  polarityPrint <<- rv$polarityPrint
  sourceGasPrint <<- rv$sourceGasPrint
  
  ## Update lowres and epsilon for printing 
  
  if(input$lowres==TRUE){
    rv$mz_tol = 1
  }
  epsilon_0_print <<- rv$mz_tol
  
  
  if (rv$mz_tol == 1){
    lowres_print <<- "Yes" 
    SearchMode = "LowRes"
  } else {
    lowres_print <<- "No"
    SearchMode = "HiRes"
  }
  updateCheckboxInput(session, "lowres", value = input$lowres)
  

  # Get noise intensity threshold
  NoiseIntensityThreshold = 0.01
  

  return(list(RefLibrary, SearchMode, hideTargetsPrint, target_min_ab_print,
              NoiseIntensityThreshold, epsilon_0_print))
}

## init_searchParams ###########################################################
# Initialize advanced settings, printed settings, etc
init_searchParams <- function(RefLibrary, iPrecursorMZ, iBP){
  
  # # Update RefLibrary to be a subset of classes selected 
  # # from classesSelect input
  # # If the dimensions of class_Select are null, a subset has been chosen
  # if (is.null(dim(class_selected)[1])){
  #   # Must use length of class_selected to get a valid value (R problem)
  #   if (numClasses != length(class_selected)){
  #     RefLibrary = RefLibrary[RefLibrary$Class %in% c(class_selected), ]
  #     class_selected_print <<- paste(as.character(class_selected), 
  #                                    collapse=", ")
  #     if (length(class_selected) == 1){
  #       class_field <<- "Search by Class: "
  #     } else {
  #       class_field <<- "Search by Classes: "
  #     }
  #   }
  # } else {
  #   class_field <<- "Search by Class: "
  #   class_selected_print <<- "All Classes"
  # }



  
  # ## Local variables returned
  # # Update rv and epsilon based on user input
  # if(rv$target_type=="Protonated Molecule"){
  #   # cat(paste("Possible Matches for Target ",i," with protonated molecule mz ",round(targets[i],1)," (stage 1 search):\n",sep=""))
  #   index_of_interest = iPrecursorMZ
  # } else if (rv$target_type=="Base Peak"){
  #   # cat(paste("Possible Matches for Target ",i," with base peak mz ",round(targets[i],1)," (stage 1 search):\n",sep=""))
  #   index_of_interest = iBP
  # } else {
  #   # If negative library
  #   index_of_interest = iPrecursorMZ
  # }

  return(list(index_of_interest, RefLibrary))

}

## fileConfigDisplay ###########################################################
# Depending on number of files this helper function defines Query1, Query2, and
# Query3, and also controls some of the mainpanel dispaly 
# all based on number and order of file uploads
fileConfigDisplay <- function(){
  
  Query1 <-  Query2 <- Query3 <- NULL
  ## File uploads
  # If single file upload 
  if (isTruthy(rv$datapathq30) && !isTruthy(rv$datapathq60) &&
      !isTruthy(rv$datapathq90)){
    NumSpectra <<- 1
    
    Query1 = asm_spec2dt(asm_specImport(rv$datapathq30))
    # rv$bpN_Query1 = asm_bpNormalizer(Query1)
    rv$fileq30 <- input$q30$name
    
    
  }
  
  # If two file upload
  else if ((isTruthy(rv$datapathq30) && isTruthy(rv$datapathq60) && 
            !isTruthy(rv$datapathq90) ) || 
           ((isTruthy(rv$datapathq30) && isTruthy(rv$datapathq90) &&
             !isTruthy(rv$datapathq60))
           )
  ){
    NumSpectra <<- 2
    if ((isTruthy(rv$datapathq30) && isTruthy(rv$datapathq90) &&
         !isTruthy(rv$datapathq60))){
      rv$case_A = 1
      
      Query1 = asm_spec2dt(asm_specImport(rv$datapathq30))
      # rv$bpN_Query1 = asm_bpNormalizer(Query1)
      rv$fileq30 <- input$q30$name
      
      Query3 = asm_spec2dt(asm_specImport(rv$datapathq90))
      # rv$bpN_Query3 = asm_bpNormalizer(Query3)  
      rv$fileq90 <- input$q90$name
    } else {
      Query1 = asm_spec2dt(asm_specImport(rv$datapathq30))
      # rv$bpN_Query1 = asm_bpNormalizer(Query1)
      rv$fileq30 <- input$q30$name
      
      Query2 = asm_spec2dt(asm_specImport(rv$datapathq60))
      # rv$bpN_Query2 = asm_bpNormalizer(Query2)  
      rv$fileq60 <- input$q60$name
      
    }
    
    
    # if (identical(rv$bpN_Query1, rv$bpN_Query2)){
    #   hide("mainPanel_DST")
    #   hide("pl")
    #   show("ErrorSameFilec1")
    # } else if (identical(rv$bpN_Query1, rv$bpN_Query3)){
    #   hide("mainPanel_DST")
    #   hide("pl")
    #   show("ErrorSameFilec2")
    # } else if (identical(rv$bpN_Query2, rv$bpN_Query3)){
    #   hide("mainPanel_DST")
    #   hide("pl")
    #   show("ErrorSameFilec3")
    # }
    
    if (identical(Query1, Query2)){
      hide("mainPanel_DST")
      hide("pl")
      show("ErrorSameFilec1")
    } else if (identical(Query1, Query3)){
      hide("mainPanel_DST")
      hide("pl")
      show("ErrorSameFilec2")
    } else if (identical(Query2, Query3)){
      hide("mainPanel_DST")
      hide("pl")
      show("ErrorSameFilec3")
    }
  }
  
  # If three file uploads
  else if (isTruthy(rv$datapathq30) && isTruthy(rv$datapathq60) &&
           isTruthy(rv$datapathq90)){
    NumSpectra <<- 3
    # asm_specImport reads in MS spectrum, asm_spec2dt converts to datatable 
    # Normalize data
    # Get filenames for printing in expanded view
    Query1 = asm_spec2dt(asm_specImport(rv$datapathq30))
    # rv$bpN_Query1 = asm_bpNormalizer(Query1)
    rv$fileq30 <- input$q30$name
    
    Query2 = asm_spec2dt(asm_specImport(rv$datapathq60))
    # rv$bpN_Query2 = asm_bpNormalizer(Query2)  
    rv$fileq60 <- input$q60$name
    
    Query3 = asm_spec2dt(asm_specImport(rv$datapathq90))
    # rv$bpN_Query3 = asm_bpNormalizer(Query3)  
    rv$fileq90 <- input$q90$name
    
    
    # if (identical(rv$bpN_Query1, rv$bpN_Query2) && 
    #     (identical(rv$bpN_Query1,rv$bpN_Query3))){
    #   hide("mainPanel_DST")
    #   hide("pl")
    #   show("ErrorSameFilec0")
    # } else if (identical(rv$bpN_Query1, rv$bpN_Query2)){
    #   hide("mainPanel_DST")
    #   hide("pl")
    #   show("ErrorSameFilec1")
    # } else if (identical(rv$bpN_Query1, rv$bpN_Query3)){
    #   hide("mainPanel_DST")
    #   hide("pl")
    #   show("ErrorSameFilec2")
    # } else if (identical(rv$bpN_Query2, rv$bpN_Query3)){
    #   hide("mainPanel_DST")
    #   hide("pl")
    #   show("ErrorSameFilec3")
    # }
    
    if (identical(Query1, Query2) && 
        (identical(Query1, Query3))){
      hide("mainPanel_DST")
      hide("pl")
      show("ErrorSameFilec0")
    } else if (identical(Query1, Query2)){
      hide("mainPanel_DST")
      hide("pl")
      show("ErrorSameFilec1")
    } else if (identical(Query1, Query3)){
      hide("mainPanel_DST")
      hide("pl")
      show("ErrorSameFilec2")
    } else if (identical(Query2, Query3)){
      hide("mainPanel_DST")
      hide("pl")
      show("ErrorSameFilec3")
    }
  }
  
  return(list(Query1, Query2, Query3, NumSpectra))
}


## acquireTargets ##############################################################
# Get the targets and return to caller
acquireTargets <- function(){
  # Computing the target_min_ab number of targets with asm_targetMolecules 
  targets = asm_targetMolecules(rv$bpN_Query1,rv$target_min_ab)
  rv$targets_mz = targets[,1]
  rv$targets_in = targets[,2]
  rv$numTargets = min(MAX_TARGETS,length(rv$targets_mz[[1]]));
  
  
  # Tolerance for search
  targets = rv$targets_mz[[1]]
  
  return(targets)
}

