# RefLibSelect dropdown menu for DST tab
# Must use input$RefLibSelect_DST to avoid conflict with RefLibSelect on DBV tab
# Use rv_RefLibSelected to isolate from reactive values
# RefLibSelectDST <- function(input, rv){

observeEvent(input$RefLibSelect_DST,{
  # Display progress bar
  withProgress(message = 'Loading ...', {
    
    # Disable dropdown menu while loading
    disable("RefLibSelect_DST")
    
    # Initialize reactive values pertaining to ref library
    rv$RefLibrary_rv = readRDS(paste0("Libraries/",input$RefLibSelect_DST))
    rv$RefLibSize_rv = dim(rv$RefLibrary_rv);
    
    # Update source gas field under dropdown menu
    rv$sourceGasPrint = rv$RefLibrary_rv[1, iSourceGas, with = FALSE][[1]]
    
    # Update based on whether selected library is negative
    update_LibraryMode(input$RefLibSelect_DST)
    # Update base peak based on library mode
    basePeakHandler(input, session)
    
    # Update viewer tab library selection    
    isolate(rv_RefLibSelected <<- input$RefLibSelect_DST)
    updateSelectInput(session, "RefLibSelect",
                      selected = rv_RefLibSelected)
    
    # # recalculate the classesTable for the dropdown menu of classesSelect input
    # classesTable = find_unique_classes(rv$RefLibrary_rv)
    # # Set class_selected global variable to all classes initially
    # class_selected <<- classesTable
    # numClasses <<- dim(classesTable)[1]
    # 
    # # Update the dropdown menu with the new unique classes list
    # updateSelectInput(session, "ClassesSelect", selected = "", choices = classesTable)
    # 
    
    # Identify indices for each column in the library data table (for calling in app)
    rv$LibraryCats = colnames(rv$RefLibrary_rv)
    rv$iCode = which(rv$LibraryCats=="Code")
    rv$iName = which(rv$LibraryCats=="Name")
    rv$iFormula = which(rv$LibraryCats=="Formula")
    rv$iInChIKey = which(rv$LibraryCats=="InChIKey_gen")
    rv$iPrecursorMZ = which(rv$LibraryCats=="PrecursorMZ_gen")
    rv$iDimerProb = which(rv$LibraryCats=="DimerProb")
    rv$iSmiles = which(rv$LibraryCats=="SMILES")
    rv$iPotentialErrors = which(rv$LibraryCats=="PotentialErrors")
    rv$iMassCaliError = which(rv$LibraryCats=="MassCaliError")
    rv$iPotentialErrorsFM1 = which(rv$LibraryCats=="PotentialErrorsFM1" )
    rv$iExactMass = which(rv$LibraryCats=="AccurateMass_gen")
    rv$iStructure = which(rv$LibraryCats=="Structure_gen")
    rv$iNoiseMetric = which(rv$LibraryCats=="NoiseMetric")
    rv$iBP = which(rv$LibraryCats=="theoBP")
    rv$iEnergies = which(rv$LibraryCats=="Energies")
    rv$minEnFolder = rv$RefLibrary_rv[1,rv$iEnergies,with=FALSE][[1]][[1]][1]
    
    rv$compoundSelected <- 1
    
    rv <<- rv
    
    enable("RefLibSelect_DST")
  })
})
# }


# Output to show current library selection source gas and polarity
# These fields are also displayed in expanded_Fields.R locked in after trigger
output$RefLibDescriptors <- renderUI({
  HTML(paste0("Polarity: ",  rv$polarityPrint, "<br>", 
              "Source Gas: ", rv$sourceGasPrint))
})
