
# This function clears the current search but does not clear text fields
clearSearch <- function(input){
  observeEvent(input$clearSearch, {
    # Show progress bar
    withProgress(message = 'Clearing Search', {
      # Only clear the  text fields that have not been pre-populated from the 
      # previous session
      if (is.na(tf1)){
        shinyjs::reset("entry1") 
      }
      if (is.na(tf2)){
        shinyjs::reset("entry2") 
      }
      if (is.na(tf3)){
        shinyjs::reset("entry3") 
      }
      if (is.na(tf4)){
        shinyjs::reset("entry4") 
      }
      if (is.na(tf5)){
        shinyjs::reset("entry5") 
      }
   
      # Reset file inputs (required to clear current upload)
      reset("q30")
      reset("q60")
      reset("q90")
      # Hide main panel and warnings
      hide("mainPanel_DST")
      hide("ErrorSameFilec0")
      hide("ErrorSameFilec1")
      hide("ErrorSameFilec2")
      hide("ErrorSameFilec3")
      hide("ErrorNoFile")
      # Reset file info for expanded view
      rv$fileq30 <- rv$fileq60 <- rv$fileq90 <- "No file selected" 
      rv$datapathq30 <- rv$datapathq60 <- rv$datapathq90 <- ""
      rv$case_A = 0
      
      # # recalculate the classesTable for the dropdown menu of classesSelect input
      # classesTable = find_unique_classes(rv$RefLibrary_rv)
      # # Set class_selected global variable to all classes initially
      # class_selected <<- classesTable
      # numClasses <<- dim(classesTable)[1]
      # updateSelectInput(session, "ClassesSelect",
      #                   selected = class_selected)
      
      # If there are no class selections, delete this session file
      if (file.exists('../shinyLastSessionClasses.csv')){
        unlink("../shinyLastSessionClasses.csv", force=TRUE)
      }
      
    }) # End withProgress
  }) # end observeEvent
}
