# RefLibSelect dropdown menu for DST tab
# Must use input$RefLibSelect_DST to avoid conflict with RefLibSelect on DBV tab
# Use rv_RefLibSelected to isolate from reactive values
ClassesSelect <- function(input, rv){

  observeEvent(input$ClassesSelect,{

    
    class_selected <<- input$ClassesSelect
    numClasses <<- dim(classesTable)[1]
    # For debugging
    # print(paste0("num classesC: ", numClasses))
    # print(paste0("length class_selectedC: ", length(class_selected)))
    # 

    # # update the dropdown menu
    # updateSelectInput(session, "ClassesSelect",
    #                   selected = class_selected)

  })
}


# When clear all button is pressed, clear selected classes
# and delete previous session data
observeEvent(input$ClearClasses, {
  
  
  # reset("ClassesSelect")
  
  # recalculate the classesTable for the dropdown menu of classesSelect input
  classesTable = find_unique_classes(rv$RefLibrary_rv)
  # Set class_selected global variable to all classes initially
  class_selected <<- classesTable
  numClasses <<- dim(classesTable)[1]
  updateSelectInput(session, "ClassesSelect",
                    selected = class_selected)
  
  # If there are no class selections, delete this session file
  if (file.exists('../shinyLastSessionClasses.csv')){
    unlink("../shinyLastSessionClasses.csv", force=TRUE)
  }
  
})