
## =============================================================================

# TITLE: mainPanel_downloadpresets.R

# DESCRIPTION: 
# This function saves a .csv of the currently selected parameters

## =============================================================================

output$downloadData <- downloadHandler(
  # Function for generating filename
  filename = function() {
    paste0("DST_preset-", as.numeric(Sys.time()), ".csv")
  },
  # Function for creating dataframe to csv
  content = function(file){
    rv_df = data.frame(input$entry1, 
                       input$entry2,
                       input$entry3,
                       input$entry4,
                       input$entry5,
                       input$target_min_ab/100, 
                       # input$searchType,
                       # input$target_type,
                       input$lowres,
                       input$epsilon_0,
                       rv_RefLibSelected, 
                       rv$hideTargets
    )
    write.csv(rv_df, file)
  }
)