## =============================================================================

# TITLE: mainPanel_Toggle_DST.R

# DESCRIPTION: 
# Show/hide certain features of DST tab when in Interactive vs Reporting view.
# Makes use of helper functions to show/hide expanded targets, helpers defined
# in source/ServerFunctions/getHashID.R

## =============================================================================


observeEvent(input$toggle_DST, {
  if(input$toggle_DST == "Interactive"){
    
    # INTERACTIVE VIEW 
    
    # SHOW THESE 
    show("MessageRow")
    show("side-panel")
    show("QueryPlots")
    show("UIRow")
    show("targets")
    show("searchType")
    show("textfieldrow")
    show("commentrow")
    show("pl")
    # Show interactive targets 
    show("interactiveTargets")
    show("interactivetable")
    show("targetsUI")  
    
    # HIDE THESE 
    hide("fields")
    hide("query-spectra-panel")
    hide("adv-panel")
    hide("targets2")
    hide("AllQueryPlots1")
    hide("AllQueryPlots2")
    hide("AllQueryPlots3")
    hide("peakListTitle1")
    hide("peakListTitle2")
    hide("peakListTitle3")
    hide("expandedPeakList1")
    hide("expandedPeakList2")
    hide("expandedPeakList3")
    
    # Hide expanded targets
    showHide_showidx(showidx, 1)
    
  } else {
    
    # REPORTING VIEW

    # SHOW THESE 
    show("fields")
    show("AllQueryPlots1")
    show("peakListTitle1")
    show("expandedPeakList1")
    show("targets2")
    # If two files uploaded
    if (NumSpectra == 2){
      show("peakListTitle2")
      show("expandedPeakList2")
      show("AllQueryPlots2")
    }
    # If three files uploaded
    if (NumSpectra == 3){
      show("peakListTitle2")
      show("peakListTitle3")
      show("expandedPeakList2")
      show("expandedPeakList3")
      show("AllQueryPlots2")
      show("AllQueryPlots3")
    }
    
    # Compute targets to show in expanded view
    # if (!is.null(allTargets)){
    showtargets_exp(showidx, allTargets) 
    
    # Show expanded targets
    showHide_showidx(showidx, 2)
    
    # HIDE THESE
    hide("pl")
    hide("textfieldrow")
    hide("commentrow")
    hide("searchType")
    hide("MessageRow")
    hide("side-panel")
    hide("UIRow")
    hide("QueryPlots")
    hide("targets")
    # Hide interactive targets 
    hide("interactiveTargets")
    hide("interactivetable")
    hide("targetsUI")
  }
})
