## =============================================================================

# TITLE: mainPanel_RestoreDefaults.R

# DESCRIPTION: 
# This function restores all settings to default without requiring closing the 
# program. The shinyLastSession.csv is also deleted and previous search cannot
# be restored

## =============================================================================

observeEvent(input$resetEntries, {
  # Show progress bar
  withProgress(message = 'Restoring Defaults', {
    
    # Reset file inputs (required to clear current upload)
    reset("q30")
    reset("q60")
    reset("q90")
    
    # Hide main panel and warnings
    hide("mainPanel_DST")
    hide("ErrorSameFilec0")
    hide("ErrorSameFilec1")
    hide("ErrorSameFilec2")
    hide("ErrorSameFilec3")
    hide("ErrorNoFile")
    
    # Reset file info for expanded view
    rv$fileq30 <- rv$fileq60 <- rv$fileq90 <- "No file selected" 
    rv$datapathq30 <- rv$datapathq60 <- rv$datapathq90 <- ""
    rv$case_A = 0
    
    # Reset setting
    if (rv$hideTargets == TRUE){
      hideTargetsPrint <<- "Yes"
    } else {
      hideTargetsPrint <<- "No"
      
    }
    
    # Clear text entries
    updateTextInput(session, "entry1", value = "")
    updateTextInput(session, "entry2", value = "")
    updateTextInput(session, "entry3", value = "")
    updateTextInput(session, "entry4", value = "")
    updateTextInput(session, "entry5", value = "")
    
    # Update select, checkbox, and slider inputs back to default
    # updateSelectInput(session, "searchType",
    #                   selected = "ma")
    updateCheckboxInput(session, "lowres", value = FALSE)
    updateCheckboxInput(session, "hideTargets", value = FALSE)
    updateSliderInput(session, "epsilon_0", value = 0.005)
    updateSliderInput(session, "target_min_ab", value = 5)
    
    
    # if (input$target_type == "Base Peak"){
    #   negLibrary = any(rv$RefLibrary_rv[,polarity] == "Negative")
    #   if (negLibrary){
    #     updateRadioButtons(session, "target_type",
    #                        selected = "Deprotonated Molecule")
    #   } else {
    #     updateRadioButtons(session, "target_type",
    #                        selected = "Protonated Molecule")
    #   }
    # }
    # 
    # Don't reset chosen library
    # # Reset library selection
    # rv_RefLibSelected <<- Libraries[1]
    # updateSelectInput(session, "RefLibSelect",
    #                   selected = rv_RefLibSelected)
    
    # # recalculate the classesTable for the dropdown menu of classesSelect input
    # classesTable = find_unique_classes(rv$RefLibrary_rv)
    # # Set class_selected global variable to all classes initially
    # class_selected <<- classesTable
    # numClasses <<- dim(classesTable)[1]
    # updateSelectInput(session, "ClassesSelect",
    #                   selected = class_selected)
    # 
    
    # Delete the last session info
    if (file.exists('../shinyLastSession.csv')){
      unlink("../shinyLastSession.csv", force=TRUE)
    }
    # # If there are no class selections, delete this session file
    # if (file.exists('../shinyLastSessionClasses.csv')){
    #   unlink("../shinyLastSessionClasses.csv", force=TRUE)
    # }
    
    
  }) # End withProgress
}) # End observeEvent

