## =============================================================================

# TITLE: mainPanel_LoadParams.R

# DESCRIPTION: 
# This function loads saved parameters from user uploaded parameter profile  
# using helper function file.choose2 for file selection

# TABLE OF cONTENTS: 

#       1) LOAD PARAMS
#       2) HELPER FUNCTION
#           2A) File loader
#           2B) Check for empty entry

## =============================================================================
##                            1) LOAD PARAMS
## =============================================================================

observeEvent(input$file, {
    # Call helper function to find file
    path <- file.choose2()
    if (!is.null(path)){
      # If a valid file, load in data
      dat <<- read.csv(file = path)
      observe({
        updateTextInput(session, "entry1",
                        value = dat$input.entry1)
        updateTextInput(session, "entry2",
                        value = dat$input.entry2)
        updateTextInput(session, "entry3",
                        value = dat$input.entry3)
        updateTextInput(session, "entry4",
                        value = dat$input.entry4)
        updateTextInput(session, "entry5",
                        value = dat$input.entry5)
        
        # If loaded preset is empty, tag that preset to be cleared
        tf1 = checkEmpty(dat$input.entry1)
        tf2 = checkEmpty(dat$input.entry2)
        tf3 = checkEmpty(dat$input.entry3)
        tf4 = checkEmpty(dat$input.entry4)
        tf5 = checkEmpty(dat$input.entry5)
        
        # Update library selected
        rv_RefLibSelected <<- dat$rv_RefLibSelected
        
        # Update inputs
        target_min_ab <- dat$input.target_min_ab
        updateSliderInput(session, "target_min_ab", value = target_min_ab*100)
        updateSelectInput(session, "searchType",
                          selected = dat$input.searchType)
        updateSelectInput(session, "target_type",
                          selected = dat$input.target_type)
        updateCheckboxInput(session, "lowres", value = dat$input.lowres)
        updateSliderInput(session, "epsilon_0", value = dat$input.epsilon_0)
        updateSelectInput(session, "RefLibSelect",
                          selected = rv_RefLibSelected)
        updateCheckboxInput(session, "hideTargets", value = dat$rv.hideTargets)
      })
    }
})

## =============================================================================
##                          2) HELPER FUNCTIONS
## =============================================================================
## -----------------------------------------------------------------------------
## 2a) File loader
## -----------------------------------------------------------------------------
# Helper function for loading in selected file
file.choose2 <- function(){
  
  pathname <- NULL
  tryCatch({
    pathname <- file.choose();
  }, error = function(ex) {
  })
  pathname;
}

## -----------------------------------------------------------------------------
## 2b) Check for empty entry
## -----------------------------------------------------------------------------

checkEmpty <- function(inpt){
  if (inpt == "" || is.na(inpt)){
    tf1 <<- NA
  } else {
    tf1 <<- inpt
  }
  return(tf1)
}