
# This program contains outputs for QueryPlotsUI and the QueryPlots for display
# of the query spectra tabs and their plots for interactive view in the search
# tab

## QueryPlotsUI ################################################################
# Create the UI for 30/60/90V tabs or any other combination of file uploads
# such as 30V only, 30/60V, and 30/90V spectra
output$QueryPlotsUI <- renderUI({
  
  if (rv$currtrigger == 1) { 
    # Select between two separate trigger buttons
    trigger_button()
  } else if (rv$currtrigger == 2) {
    trigger_button2()
  } else {
    return()
  }
  
  # If the files uploaded are 30 and 90, rv$case_A is equal to 1
  if (rv$case_A == 1){ 
    QueryType = c("Low (30 V)", "High (90 V)")
    
  } else {
    QueryType = c("Low (30 V)", "Mid (60 V)", "High (90 V)")
    QueryType = QueryType[1:NumSpectra]
  }
  
  # Create a tab for each spectra using input$plottabQ
  do.call(tabsetPanel, c(id='plottabQ',lapply(1:NumSpectra, function(i) {
    tabPanel(title=QueryType[i])
    
  })))
})

## plottabQ ####################################################################
# Plot current tab
observeEvent(input$plottabQ, {
  k = input$plottabQ
  rv$QuerySelected <- k;
  
})

## QueryPlots ##################################################################

# Create the actual plots within each tab for interactive view
output$QueryPlots <- renderPlotly({
  
  if (!getTriggerButton()){return()}
  
  # Select data depending on tab
  if(rv$QuerySelected == "Low (30 V)"){
    plottitle = paste0("Low (30 V) ", rv$fileq30)
    bpn_data = Results$Q1
  } else if (rv$QuerySelected == "Mid (60 V)"){
    plottitle = paste0("Mid (60 V) ",  rv$fileq60)
    bpn_data = Results$Q2;
  } else if (rv$QuerySelected == "High (90 V)"){
    plottitle = paste0("High (90 V) ",  rv$fileq90)
    bpn_data = Results$Q3;
  }
  

  # Init target, threshold, annotations
### targets = rv$targets_mz;
  targets = Results$TARGETS
  target_min_ab = rv$target_min_ab;
  l = dim(bpn_data)[1];
  # col = rep("black",l)
  col = rep("Non-target ion",l)
  annotations = rep("",l);
  
  # Iterate through targets
  for(i in 1:length(targets[[1]])){
    # Get index of target in data
    j = which.min(abs(bpn_data[,mz]-targets[[1]][i]))
    # Only use targets below certain threshold
    # targets[[1]] is the column containing target mz, targets[[2]] is target ab
    if((abs(bpn_data[j,mz]-targets[[1]][i]) <= rv$mz_tol)){
      if(rv$QuerySelected == "Low (30 V)"){

        if (is.null(Results$SearchResults)[1]){
          # col[j] = "blue"
          col[j] = "Target ion w/o match"
          annotations[j] = paste0("Target ion w/o matches\n");
        } else if ((Results$SearchResults[i][[1]] == "NA")[1] || 
            (Results$SearchResults[i] == "NULL")[1]){
          
          # col[j] = "blue"
          col[j] = "Target ion w/o match"
          annotations[j] = paste0("Target ion w/o matches\n");
        } else {
          # col[j] = "red";
          col[j] = "Target ion w/ possible matches"
          annotations[j] = paste0("Target ion w/ possible matches\n");
        }
        #annotations[j] = paste0("Non-target ion\n");
      } else {
        col[j] = "Ion within error tolerance of a Target ion";
        annotations[j] = paste0("Ion within error tolerance of a Target ion");
      }
    }
  }
  
  # Create plot with color-coded annotations defined above
  bpn_data = cbind(bpn_data, annotations)
  bpn_data = cbind(bpn_data, col)
  
  p <- ggplot(bpn_data, aes(x = mz, 
                            ymax = ab, 
                            ymin = 0,
                            fill = col,
                            text = paste0(annotations, 
                                          "m/z: ", round(mz, 4), 
                                          "\nrel. int.: ", round(ab, 1))))
  
  # Must use linerange for line to x-axis style plots
  p <- p + geom_linerange(aes(color = col), show.legend = FALSE)

  # p <- p + scale_color_manual(name = "Legend",
  #                             labels = c("helloooo", "are you there", "c"),
  #                             values = c("blue", "red", "black"))

  p <- p + labs(title = "", #plottitle,
                x = "m/z",
                y = "Relative Intensity (%)")

  p <-p + theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.background = element_blank(),
    axis.line = element_line(color = "black"),
    axis.title.x = element_text(face="italic", size = 10),
    axis.title.y = element_text(size=10),
    
  )
  p <- p + scale_x_continuous(limits = c(rv$xmin_dst, rv$xmax_dst),
                              breaks= seq(rv$xmintick_dst, 
                                  rv$xmaxtick_dst, rv$increment_dst
                              ),
                              expand = c(0,0)
  ) + scale_y_continuous(expand = c(0,0)) + expand_limits(x = 0, y = 0)
  
  # If mixture analysis also show threshold bar for target_min_ab
  if(rv$QuerySelected == "Low (30 V)"){
    p <- p + geom_hline(aes(yintercept=99.9*target_min_ab_print,
                            color="Targetting Threshold"),
                        show.legend = FALSE,
                        linetype="dotted",
                        size=0.25,
    )
  }
  
  
  p <- p + scale_color_manual(
    values = c('Target ion w/ possible matches'='red', 
               'Target ion w/o match'='blue',
               'Non-target ion'='black',
               'Targetting Threshold' = 'purple',
               'Ion within error tolerance of a Target ion' = 'orange')
  )
  

  # Create the plot
  myplot = ggplotly(p, tooltip=c('text')) %>% layout(
    legend = list(
      orientation = "h",
      x = 0, xanchor = "left",
      y = 1.2, yanchor = "center")
    )
  
  for (i in 1:length(myplot$x$data)){
    if (!is.null(myplot$x$data[[i]]$name)){
      myplot$x$data[[i]]$name =  gsub("\\(","",str_split(myplot$x$data[[i]]$name,",")[[1]][1])
    }
  }
  
  rv$axisLimitsDone = TRUE
  myplot
  
})