# This program contains two outputs, peakListUI and interactivePeakList
# These outputs create the three tabs to be selected from the peak list and 
# the peak list itself for the interactive view of the search tab

## pltab #######################################################################
observeEvent(input$pltab, {
  l = input$pltab
  rv$pltabSelected <- l;
})

## peakListUI ##################################################################
# Create the tabs for the interactive peak list
output$peakListUI <- renderUI({
  if (rv$currtrigger == 1) { 
    # Select between two separate trigger buttons
    trigger_button()
  } else if (rv$currtrigger == 2) {
    trigger_button2()
  } else {
    return()
  }
  
  # Create the actual tabs
  choices = c("Threshold", "Top 10","All Peaks")
  do.call(tabsetPanel, c(id='pltab', lapply(1:length(choices), function(i){
    tabPanel(title=choices[i])
    
  })))
})

## interactivePeakList ########################################################
# Create the interactive peak list based on selection
output$interactivePeakList <- renderDataTable({

  # Only proceed if trigger button pressed
  if (!getTriggerButton()){
    return()
  }

  
  # # Select data depending on tabreturn 
  # if(rv$QuerySelected == "Low (30 V)"){
  #   bpn_data = rv$bpN_Query1; 
  # } else if (rv$QuerySelected == "Mid (60 V)"){
  #   bpn_data = rv$bpN_Query2;
  # } else if (rv$QuerySelected == "High (90 V)"){
  #   bpn_data = rv$bpN_Query3;
  # }
  
  # Select data depending on tabreturn 
  if(rv$QuerySelected == "Low (30 V)"){
    bpn_data = Results$Q1
  } else if (rv$QuerySelected == "Mid (60 V)"){
    bpn_data = Results$Q2
  } else if (rv$QuerySelected == "High (90 V)"){
    bpn_data = Results$Q3
  }
  
  targets = rv$targets_mz[[1]]
  n = length(targets)
  annotations = data.frame(
    x = numeric(n),
    y = numeric(n),
    label = character(n),
    idx = numeric(n)
  )
  
  # For each target, create label for annotations formatted "T1, T2, etc..."
  for (i in 1:n) {
    # Find index j for data
    j = which.min(abs(bpn_data[, mz] - targets[i]))
    targetlabel = ""
    targetlabel = paste0("T", as.character(i))
    # Update annotation x,y coordinates, label and index
    annotations$x[i] <- targets[i]
    annotations$y[i] <- as.numeric(unlist(bpn_data[j, 2])) + 5
    annotations$label[i] <- targetlabel
    annotations$idx[i] <- j
  }
  
  # Sort in descending order
  bpn_data = bpn_data[order(-bpn_data$ab),]

  
  if (rv$QuerySelected == "Low (30 V)"){
    # Compute the data
    # bpn_data = return_expanded_bpn(bpn_data)
    len = dim(bpn_data)[1]
    
    # For each index
    for (i in 1:len){
      
      
      # If an annotation exists, add to target_annotations
      if (isTruthy(annotations$label[i])){
        target_annotations[i] = annotations$label[i]
      } else {
        target_annotations[i] = ""
      }
    }

    rv$completeAnnotations = target_annotations
    
    # Save target annotations
    bpn_data$targets <- target_annotations
    
    # Rename column
    bpn_data = format_peakList(bpn_data, "Low (30 V)")
    
  } else {

    bpn_data = format_peakList(bpn_data, "Other")
  }
  
  
  # # Get threshold value for Threshold tab
  # cutoff <<- target_min_ab_print*100
  # 
  # Edit bpn_data based on current tab selection
  # if (rv$pltabSelected == "Top 10"){
  #   bpn_data = bpn_data[1:10]
  # } else if (rv$pltabSelected == "Threshold") {
  #   bpn_data = bpn_data[which(bpn_data[,2] >= cutoff),]
  # } else {
  #   bpn_data = bpn_data
  # }
  
  
  
  # Sort data in decreasing order
  return(bpn_data)
  
},
selection = 'single',      # Must come first
escape = FALSE,            # Allow HTML such as italics <em> </em>
rownames = FALSE,
options = list(dom  = 'ltp',
               # autowidth=TRUE,
               lengthMenu = list(c(10, 30, -1), c('10', '30', 'All')),

               rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}"),
               columnDefs = list(list(width='30px', targets = c(0,1)))
               
)

)

format_peakList <- function(bpn_data, mode){
  if (mode == "Low (30 V)"){
    # Rename columns
    colnames(bpn_data)[1] = paste0("<em>m/z</em>")
    colnames(bpn_data)[2] = "Relative Intensity"
    colnames(bpn_data)[3] = "Target"
    
    # # Format sigfigs
    bpn_data[,1] = format(round(bpn_data[,1],4), nsmall=4)
    bpn_data[,2] = format(round(bpn_data[,2],1))
    
    return(bpn_data)
    
  } else if (mode == "+30 V" || mode == "+60 V" || mode == "+90 V"){
    # Library spectra found here
    RefLibrary = rv$RefLibrary_rv
    
    j = rv$compoundSelected;
    # k = '+30 V' for example
    # i = index 1 = +30V, 2 = +60V etc
    i = which(unlist(RefLibrary[j,Energies])==mode);
    # Load data for current compound, normalize and sort descending
    bpn_data = as.data.table(RefLibrary[j,PeakLists][[1]][i]); 
    bpn_data = asm_bpNormalizer(bpn_data, "HiRes", 0, 0)
    bpn_data = bpn_data[order(-bpn_data$ab),]
    
    # REname columns
    colnames(bpn_data)[1] = paste0("<em>m/z</em>")
    colnames(bpn_data)[2] = "Relative Intensity"
    # Format sigfigs
    bpn_data[,1] = format(round(bpn_data[,1],4), nsmall=4)
    bpn_data[,2] = format(round(bpn_data[,2],1))
    return(bpn_data)
    
  } else if (mode == "Other") {
    # REname columns
    colnames(bpn_data)[1] = paste0("<em>m/z</em>")
    colnames(bpn_data)[2] = "Relative Intensity"
    # Format sigfigs
    bpn_data[,1] = format(round(bpn_data[,1],4), nsmall=4)
    bpn_data[,2] = format(round(bpn_data[,2],1))
    return(bpn_data)
  }
  
  
}


