
## =============================================================================

# TITLE: expanded_QueryPlots.R

# DESCRIPTION: 

# A separate renderPlot call is used for each individual plot
# This program creates the reporting view for query plots 30 V, 60 V, 90 V and 
# any combination of these spectra for dynamic number of file uploads
# It makes use of expanded_Plots.R helper functions

# TABLE OF cONTENTS: 
#     1) AllQueryPlots1 - Low (30 V) Spectra
#     2) AllQueryPlots2 - Mid (60 V) Spectra
#     3) AllQueryPlots3 - High (90 V) Spectra


## =============================================================================
## 1) AllQueryPlots1 - Low (30 V) Spectra
## =============================================================================


# Create all of the plots for expanded view 
output$AllQueryPlots1 <- renderPlot({
  # Only proceed if trigger button pressed
  if (!getTriggerButton()){
    return()
  }
  
  # Get data for first query
  # bpn_data = rv$bpN_Query1
  bpn_data = Results$Q1
  
  # Create annotated plot with data and title parameters
  # rv$targets_mz[[1]] is for targets 
  create_ggplot_annotate(bpn_data, paste0("Low (30 V) ", rv$fileq30), rv$targets_mz[[1]])
})

## =============================================================================
## 2) AllQueryPlots2 - Mid (60 V) Spectra
## =============================================================================

# Repeat for queryPlots 2 and 3
output$AllQueryPlots2 <- renderPlot({
  # Only proceed if trigger button pressed
  if (!getTriggerButton()){
    return()
  }
  
  # hide("AllQueryPlots2")
  if (NumSpectra > 1 && rv$case_A == 0){
    # bpn_data = rv$bpN_Query2
    bpn_data = Results$Q2
    
    create_ggplot(bpn_data, paste0("Low (60 V) ", rv$fileq60))
  } else if (NumSpectra > 1 && rv$case_A == 1){
    # bpn_data = rv$bpN_Query3
    bpn_data = Results$Q3
    
    create_ggplot(bpn_data, paste0("High (90 V) ", rv$fileq90))
  }
})

## =============================================================================
## 3) AllQueryPlots3 - High (90 V) Spectra
## =============================================================================

output$AllQueryPlots3 <- renderPlot({
  # Only proceed if trigger button pressed
  if (!getTriggerButton()){
    return()
  }
  
  if (NumSpectra > 2){
    # show("AllQueryPlots3")
    # bpn_data = rv$bpN_Query3
    bpn_data = Results$Q3
    
    create_ggplot(bpn_data, paste0("High (90 V) ", rv$fileq90))
  }
})


