## =============================================================================

# TITLE: expanded_PeakList.R

# DESCRIPTION: 

# The purpose of this program is to define the expanded view peak lists 
# This is done by output$expandedPeakList1, 2 and 3 as well as a helper
# which returns the data based on the currently selected tab from the
# interactive view


# TABLE OF cONTENTS: 

# 1) EXPANDED PEAK LISTS (1 - 3)
#     1A) EXPANDED PEAK LIST 30 V
#     1B) EXPANDED PEAK LIST 60 V
#     1C) EXPANDED PEAK LIST 90 V

## =============================================================================
## 1) EXPANDED PEAK LISTS (1 - 3)
## =============================================================================
## -----------------------------------------------------------------------------
## 1A) EXPANDED PEAK LIST 1
## -----------------------------------------------------------------------------

# Display raw peak tables for 30 V query spectra in reporting view
output$expandedPeakList1 <- renderDataTable({
  
  # Only proceed if trigger button pressed
  if (!getTriggerButton()){
    return()
  }
  
  # Select data 
  # bpn_data = rv$bpN_Query1; 
  bpn_data = Results$Q1
  # Reverse sorted order
  bpn_data = bpn_data[order(-bpn_data$ab),]
  
  
  # # Compute the data
  # len = dim(bpn_data)[1]
  # 
  # # For each index
  # for (i in 1:len){
  #   # If an annotation exists, add to target_annotations
  #   if (isTruthy(rv$annotations[i])){
  #     target_annotations[i] = rv$annotations[i]
  #   } else {
  #     target_annotations[i] = ""
  #   }
  # }
  # 
  # Save target annotations
  # bpn_data$targets <- target_annotations
  bpn_data$targets <- rv$completeAnnotations
  
  bpn_data = format_peakList(bpn_data, "Low (30 V)")
  
  # Sort data in decreasing order
  return(bpn_data)
  
},
selection = 'single',
escape = FALSE,            # Allow HTML such as italics <em> </em>
rownames = FALSE,
options = list(dom  = 'ltp',
               autowidth=TRUE,
               lengthMenu = list(c(10, 30, -1), c('10', '30', 'All')),
               rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}")
)


)

## -------------------------------------------------------------------------
## 1B) EXPANDED PEAK LIST 2
## -------------------------------------------------------------------------
# Output peak list for 60 V spectra when 2-3 spectra
# Also handles non-standard input such as 30 V and 90 V here
output$expandedPeakList2 <- renderDataTable({
  
  # Only proceed if trigger button pressed
  if (!getTriggerButton()){
    return()
  }
  
  # Reset display and data
  hide("expandedPeakList2")
  hide("expandedPeakList3")
  bpn_data = NA
  
  # If more than 1 spectra selected, if not don't do anything
  if (NumSpectra > 1){
    # If standard input (30 V/60 V)
    if (rv$case_A == 0){
      show("expandedPeakList2")
      # Select data depending on tab
      # bpn_data = rv$bpN_Query2; 
      bpn_data = Results$Q2
      # Reverse sort data
      bpn_data = bpn_data[order(-bpn_data$ab),]
      
    } else { 
      # Non standard output (30 V/ 90 V)
      show("expandedPeakList2")
      # Use query 3 for data instead of Mid
      # bpn_data = rv$bpN_Query3; 
      bpn_data = Results$Q3
      # Reverse sort data
      bpn_data = bpn_data[order(-bpn_data$ab),]
      
    }
  }
  
  bpn_data = format_peakList(bpn_data, "Other")
  # Sort data in decreasing order
  return(bpn_data)
  
},
selection = 'single',

escape = FALSE,            # Allow HTML such as italics <em> </em>
rownames = FALSE,
options = list(dom  = 'ltp',
               autowidth=TRUE,
               lengthMenu = list(c(10, 30, -1), c('10', '30', 'All')),
               rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}")
)

)

## -------------------------------------------------------------------------
## 1C) EXPANDED PEAK LIST 3
## -------------------------------------------------------------------------
# Output for 90 V in standard case (30 V/60 V/90 V)
output$expandedPeakList3 <- renderDataTable({
  
  # Only proceed if trigger button pressed
  if (!getTriggerButton()){
    return()
  }
  
  # Reset data
  bpn_data = NA
  if (NumSpectra > 2){
    show("expandedPeakList3")
    
    # Select data depending on tab
    # bpn_data = rv$bpN_Query3; 
    bpn_data = Results$Q3
    # Reverse sort data
    bpn_data = bpn_data[order(-bpn_data$ab),]
    
  }
  bpn_data = format_peakList(bpn_data, "Other")
  
  # Sort data in decreasing order
  return(bpn_data)
  
},
selection = 'single',

escape = FALSE,            # Allow HTML such as italics <em> </em>
rownames = FALSE,
options = list(dom  = 'ltp',
               autowidth=TRUE,
               lengthMenu = list(c(10, 30, -1), c('10', '30', 'All')),
               rowCallback = JS("function(r,d) {$(r).attr('height', '10px')}")
)

)


