## =============================================================================

# TITLE: expanded_Fields.R

# DESCRIPTION: 
# This program creates a table in Expanded view of DST for current parameters

# TABLE OF CONTENTS: 
# 1) INITIALIZE FIELDS
# 2) RENDER DATATABLE 

## =============================================================================

output$fields <- renderTable({
  
  ## =============================================================================
  ## 1) INITIALIZE FIELDS
  ## =============================================================================
  
  # Only proceed if trigger button pressed
  if (!getTriggerButton()){
    return()
  }
  
  # If search not yet conducted, set base values for all fields that could be
  # displayed in 'Reporting' view
  # if (is.null(target_min_ab_print) || is.null(target_type_print) 
  #     || is.null(lowres_print) || is.null(mz_tol_print)){
  #   target_min_ab_print = "Search not yet conducted"
  #   target_type_print = "Search not yet conducted"
  #   lowres_print = "Search not yet conducted"
  #   mz_tol_print = "Search not yet conducted"
  #   
  # } 
  # 
  # Initialize text field entries
  if (!isTruthy(input$entry1)){
    entry1 = "None"
  } else {
    entry1 = input$entry1
  }
  if (!isTruthy(input$entry2)){
    entry2 = "None"
  }  else {
    entry2 = input$entry2
  }
  if (!isTruthy(input$entry3)){
    entry3 = "None"
  }  else {
    entry3 = input$entry3
  }
  if (!isTruthy(input$entry4)){
    entry4 = "None"
  } else {
    entry4 = input$entry4
  }
  if (!isTruthy(input$entry5)){
    entry5 = "None"
  } else {
    entry5 = input$entry5
  }
  
  

  
  # Turn target_min_ab to a percentage rather than decimal
  if (is.numeric(target_min_ab_print)){
    target_min_ab_print <- as.character(
      paste(as.numeric(target_min_ab_print*100), "%"))
  }
  
  # Check hideTargets setting value
  if (rv$hideTargets == TRUE){
    hideTargetsPrint <<- "Yes"
  } else {
    hideTargetsPrint <<- "No"
  }
  
  
  ## =============================================================================
  ## 2) RENDER DATATABLE 
  ## =============================================================================
  data.frame(
    Parameter = c("Date: ",
                  "Instrument ID: ",
                  "Case Number: ",
                  "Item Number: ",
                  "Library: ",
                  "Library Polarity: ",
                  "Library Source Gas: ",
                  "Filename of Low (30 V) Spectrum: ",
                  "Filename of Mid (60 V) Spectrum: ",
                  "Filename of High (90 V) Spectrum: ",
                  # "Search Mode: ",
                  # class_field, 
                  # "Target Assumption:",
                  "Display only targets with potential matches: ",
                  "Targetting threshold (%):",
                  
                  HTML("<em>m/z</em> Tolerance (&#177 Da):"),
                  "Comments: "
    ),
    Value = as.character(c(
      entry1,
      entry2, 
      entry3, 
      entry4,
      RefLibraryPrint,
      polarityPrint,
      sourceGasPrint,
      fileq30print,
      fileq60print,
      fileq90print, 
      # searchtype_print,
      # class_selected_print,
      # target_type_print,
      hideTargetsPrint,
      target_min_ab_print,
      mz_tol_print,
      entry5
    )),
    stringsAsFactors = FALSE
  )
  
  # Use a sanitizer to get correct text output
}, sanitize.text.function=function(x){x})



