## Trigger_Calculations.R

## runLength ###############################################################
runLength <- function(i, allTargets.list, runLength,
                      Query1, Query2, Query3, NumSpectra,
                      RefLibrary, iPrecursorMZ, iBP, 
                      index_of_interest, targets){
  
  # s1 used to calculate s
  s1 = as.numeric(RefLibrary[,index_of_interest, with=FALSE][[1]]);
  # s2 contains potential match data
  s2 = which(abs(s1 - as.numeric(targets[i])) < rv$mz_tol)
  
  # Length of s2 shows how many potential matches for current target i
  if(length(s2)<= 0){
    # Print no matches if else
    allTargets.list[[i]] = paste0("No matches in database")

  } else {
    
    # # 1/11 - asm_ILSA.R from batchSearchScript---------------------------------
    # 
    # # REDUNDANT - GET TARGETS
    # targets_temp = asm_targetMolecules(rv$bpN_Query1,rv$target_min_ab)
    # targets_ab = targets_temp$ab
    # targets_mz = targets_temp$mz
    # 
    # # VARIABLES 
    # 
    # mzTol = rv$mz_tol
    # epsilon_0 = mzTol;   # mz difference used to identify targets
    # epsilon_1 = 2*mzTol; # mz difference when computing scores
    # 
    # # Check if target mz might be an M+1 isotope of a previous target
    # s2i = NULL;
    # check = abs((m_neutron) - (targets_mz[i] - targets_mz[1:i])) <= epsilon_1; # we need a better error estimate on isotopes... clearly its not as simple as we thought
    # if(sum(check)>0){
    #   s1i = as.numeric(RefLibrary[,index_of_interest,with=FALSE][[1]]) + m_neutron; # all +1 isotopes of protonated molecules OR base peaks in the library
    #   s2i = which(abs(s1i - as.numeric(targets_mz[i])) < epsilon_0);     # all protonated molecules OR base peaks within epislon_0 of the target + 1 neutron 
    # }
    # 
    # # Check if target mz might be an M+2 isotope of a previous target
    # s2ii = NULL;
    # check = abs((2*m_neutron) - (targets_mz[i] - targets_mz[1:i])) <= epsilon_1;
    # if(sum(check)>0){
    #   s1i = as.numeric(RefLibrary[,index_of_interest,with=FALSE][[1]]) + 2*m_neutron; # all +2 isotopes of protonated molecules OR base peaks in the library
    #   s2ii = which(abs(s1i - as.numeric(targets_mz[i])) < epsilon_0);     # all protonated molecules OR base peaks within epislon_0 of the target + 2 neutron 
    # }
    # 
    # sTotal = c(s2,s2i,s2ii);
    # 
    # 
    # #---------------------------------------------------------------------------
    
    # Resume regular use of Trigger calculation
    allTargets.list[[i]] = potentialMatches(i, s2, runLength, 
                                    Query1, Query2, Query3, NumSpectra,
                                    RefLibrary, iPrecursorMZ, iBP, 
                                    index_of_interest, targets)
    
    # ## DEV MODE ## 
    if (dev_mode==1){
      devMode(ref_mz, mass_diff, NumRefSpec, aNPF, asm_NPFs, asm_PEs, aPE,
              asm_MFs, aMF, asm_MBs, aMB)}

  } 
  
  rv$targets_all_data[i]=list(allTargets.list[i])
  
  incProgress(i/runLength)
  
  return(allTargets.list)
  
}


## potentialMatches #########################################################

potentialMatches <- function(i, s2, runLength,
                             Query1, Query2, Query3, NumSpectra,
                             RefLibrary, iPrecursorMZ, iBP, 
                             index_of_interest, targets){

  ## Initialize empty list for this target's potential matches
  addThis.list = NULL
  ## Initialize aggregates for potential matches, for each target
  compounds_agg = c()
  fpie_agg = c()
  revmf_agg = c()
  refmz_agg = c()
  massdiff_agg = c()
  comments_agg = c()

  
  # For each target, j iterates through number of potential matches 
  for(j in 1:length(s2)){
    
    # 1/11 ---------------------------------------------------------------------
    # 
    # if(sTotal[j] %in% s2i){
    #   Comment = "(m+1) Isotope Match"
    #   ref_mz = as.numeric(RefLibrary[sTotal[j],index_of_interest,with=FALSE]) + m_neutron;
    # } else if (sTotal[j] %in% s2ii){
    #   Comment = "(m+2) Isotope Match"
    # 
    #   ref_mz = as.numeric(RefLibrary[sTotal[j],index_of_interest,with=FALSE]) + 2*m_neutron;
    # } else {
    #   Comment = "(m) Standard Match"
    # 
    #   ref_mz = as.numeric(RefLibrary[sTotal[j],index_of_interest,with=FALSE]);
    # }
    # 
    # # ------------------------------------------------------------------------
    
    
    
    # Compound name for potential match written here
    ref_mz = as.numeric(RefLibrary[s2[j],index_of_interest,with=FALSE]);
    
    mass_diff = asm_mass_diff(RefLibrary[s2[j],index_of_interest,with=FALSE],
                              RefLibrary[s2[j],MassCaliError],
                              targets[i]);
    
    # Sst - add in mass diff for printing in DT renderdatatable
    mass_diff_print = sst_mass_diff(RefLibrary[s2[j],index_of_interest,with=FALSE],
                                    targets[i]);
    
    ## sst single file edits
    NumRefSpec = as.numeric(RefLibrary[s2[j],NumSpectra][[1]])
    CEs = RefLibrary[s2[j],Energies][[1]]
    
    asm_MF = numeric(NumRefSpec)
    asm_PE = array(0,dim=c(NumRefSpec,6))  # There are 6 outputs from the Peaks Explained Function
    

    scoringResults = scoring(NumSpectra, CEs, RefLibrary, s2, j, iPrecursorMZ, 
                             asm_MF, asm_PE, Query1, Query2, Query3, NumRefSpec,
                             mass_diff)

    score1 = unpackResults(1, scoringResults)
    score2 = unpackResults(2, scoringResults)
    td_comment = unpackResults(3, scoringResults)
    
    
    # # --------------------------------------------------------------------------
    # # Add match type to comments section
    # # td_comment = "<em> (warning: no protonated molecule in query) </em>"
    # td_comment = paste0(Comment, "<br>", td_comment)
    # 
    # # print(paste0("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))
    # # # print(paste0("Td_Comment in Trigger: ", td_comment))
    # # 
    # # print(paste0("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))
    # # 
    # # --------------------------------------------------------------------------
    # 
    
    ## Aggregate each potential matches data to add to a list
    compounds_agg = c(compounds_agg, paste0(RefLibrary[s2[j],Name][[1]]))
    fpie_agg = c(fpie_agg, score1)
    revmf_agg = c(revmf_agg, score2)
    refmz_agg = c(refmz_agg, ref_mz)
    massdiff_agg = c(massdiff_agg, mass_diff_print)
    comments_agg = c(comments_agg, td_comment)
    
  } # for j
  
  ## initialize a list of lists for allTargets if this is the first i
  addThis.list = list(
    "Compound" = compounds_agg,
    "FPIE" = fpie_agg,
    "RevMF" = revmf_agg,
    "Ref m/z" = refmz_agg,
    "Mass diff." = massdiff_agg,
    "Comments" = comments_agg)
  
  return(addThis.list)
  
}

## scoring() ################################################################

scoring <- function(NumSpectra, CEs, RefLibrary, s2, j, iPrecursorMZ, 
                    asm_MF, asm_PE, Query1, Query2, Query3, NumRefSpec, 
                    mass_diff){
  
  
  for(m in 1:NumSpectra){
    iCE = CEs[m]
    
    if (rv$case_A == 1 && iCE == "+60 V"){
      iCE = "+90 V"
      m = m + 1
      
    }
    if(iCE == "+30 V"){
      Query = Query1;
    } else if (iCE == "+60 V"){
      
      Query = Query2;
    } else if (iCE == "+90 V"){
      
      Query = Query3;
    }
    
    prot_mol = as.numeric(RefLibrary[s2[j],iPrecursorMZ,with=FALSE][[1]]); 
    max_mz_consider = prot_mol + 3; # should we look beyond the prot mol to include some isotopic peaks? (discuss with ED) 
    RefPeakList = asm_spec2dt_ref(RefLibrary[s2[j],PeakLists][[1]][m],max_mz_consider);  # collect peaks up to a max mz value to avoid computations on noise 
    
    if(input$lowres==TRUE){
      rv$epsilon_0 = 1
      Query = asm_hiRes2lowRes(Query)
      RefPeakList = asm_hiRes2lowRes(RefPeakList)
      epsilon_1 = 1e-8;
    } else {
      rv$epsilon_0 = input$epsilon_0
      epsilon_1 = 2*rv$epsilon_0;
    }
    
    asm_MF[m] = asm_revMatchFactor(RefPeakList,Query,epsilon_1)
    asm_PE[m,] = asm_PeaksExplained(RefPeakList,Query,epsilon_1,prot_mol)
    
  }
  
  
  weightresults = weightcalculations(asm_PE, asm_MF, NumSpectra, NumRefSpec)
  asm_PE = unpackResults(1, weightresults)
  aPE = unpackResults(2, weightresults)
  aMB = unpackResults(3, weightresults)
  aMF = unpackResults(4, weightresults)
  # asm_PE, aPE, aMB, aMF, 
  
  # Calculate scores for targets
  score1 = mass_diff*aPE*aMB; # 1-mass diff and 1-aMB accounted for in mass_diff and aMB_respectively
  score1 = round(score1,3);
  score2 = mass_diff*aMF*aMB;
  score2 = round(score2,3);
  
  if(asm_PE[1,3]==0){
    td_comment = paste0("<em> (warning: no protonated molecule in query) </em>")
  } else {
    td_comment = ""
  }
  
  return(list(score1, score2, td_comment))
}



## weightcalculations() #####################################################


weightcalculations <- function(asm_PE, asm_MF, NumSpectra, NumRefSpec){
  
  
  # Target calculations here
  asm_PEs = round(asm_PE[,1],4)
  asm_MBs = round(asm_PE[,2],4)
  asm_NPFs = round(asm_PE[,4],4);
  asm_MFs = round(asm_MF,4)
  
  
  if (NumSpectra == 1){
    weights1 = c(1,0,0)  # should be a tunable parameter fraction of reference abundance explained
    weights2 = c(1,0,0)  # should be a tunable parameter mass bias
    weights3 = c(1,0,0)  # should be a tunable parameter reverse match factor
    weights4 = c(1,0,0)  # should be a tunable parameter fraction of reference number of peaks
  }
  if (NumSpectra == 2){
    if (rv$case_A == 1){
      weights1 = c(0.5,0,0.5)  # should be a tunable parameter fraction of reference abundance explained
      weights2 = c(0.5,0,0.5)  # should be a tunable parameter mass bias
      weights3 = c(0.5,0,0.5)  # should be a tunable parameter reverse match factor
      weights4 = c(0.5,0,0.5)  # should be a tunable parameter fraction of reference number of peaks
    } else {
      weights1 = c(0.5,0.5, 0)  # should be a tunable parameter fraction of reference abundance explained
      weights2 =  c(0.5,0.5, 0)  # should be a tunable parameter mass bias
      weights3 =  c(0.5,0.5, 0)  # should be a tunable parameter reverse match factor
      weights4 =  c(0.5,0.5, 0)  # should be a tunable parameter fraction of reference number of peaks
    }
  }
  if (NumSpectra == 3){
    weights1 = c(0.3333,0.3333,0.3333)  # should be a tunable parameter fraction of reference abundance explained
    weights2 = c(0.3333,0.3333,0.3333)  # should be a tunable parameter mass bias
    weights3 = c(0.3333,0.3333,0.3333)  # should be a tunable parameter reverse match factor
    weights4 = c(0.3333,0.3333,0.3333)  # should be a tunable parameter fraction of reference number of peaks
  }
  
  aPE = 0; # fraction of reference abundance explained by number of peaks matched
  aMB = 0; # mass bias
  aMF = 0; # reverse match factor
  aNPF = 0; # fraction of reference number of peaks matched
  
  # compute weighted values
  for(m in 1:NumRefSpec){
    aPE = aPE + weights1[m]*asm_PEs[m]
    aMB = aMB + weights2[m]*asm_MBs[m]
    aMF = aMF + weights3[m]*asm_MFs[m]
    aNPF = aNPF + weights4[m]*asm_NPFs[m]
  }
  
  aMB = 1-aMB; # mass bias should be 
  
  return(list(asm_PE, aPE, aMB, aMF))
}