# What to do once app is closed is handled here, including
# downloading the current sessions parameters to be pre-populated
# on the next session via 'LastSession.csv'

session$onSessionEnded(function() {
  # dbDisconnect(con)
  
  
  # Get current working directory
  pathout = getwd()
  # Create filename and path
  file = paste0(pathout, "LastSession.csv")
  file2 = paste0(pathout, "LastSessionClasses.csv")
  
  # Create an instance of current parameters to be saved
  isolate({
  
    tempdf <- data.frame(input$entry1, 
                         input$entry2,
                         input$entry3,
                         input$entry4,
                         input$entry5,
                         input$target_min_ab/100, 
                         input$lowres,
                         input$epsilon_0,
                         rv_RefLibSelected,
                         rv$hideTargets
                         # 
                         # db$onOff, 
                         # db$name
                         )
    
    # # Check if negative mode
    # temp_lib = readRDS(paste0("Libraries/", rv_RefLibSelected))
    # temp_negLibrary = any(temp_lib[, polarity] == "Negative")
    # 
    # # Only write to file if negative/positive library matches Target Assumption
    # if ((temp_negLibrary && input$target_type == "Deprotonated Molecule") ||
    #     (!temp_negLibrary && input$target_type == "Protonated Molecule")){
    #   # write to file
    #   write.csv(tempdf, file)
    #   
    #   
    #   # only write to second file if exists
    #   if (is.null(dim(class_selected)[1])){
    #     # Must use length of class_selected to get a valid value (R problem)
    #     if (numClasses != length(class_selected)){
    #       tempdf2 <- data.frame(class_selected)
    #       write.csv(tempdf2, file2)
    #     }
    #   } 
    #   
    # } else {
      # Base peak, proceed as usual
      # write to file
      write.csv(tempdf, file)
      
      
      # only write to second file if exists
      if (is.null(dim(class_selected)[1])){
        # Must use length of class_selected to get a valid value (R problem)
        if (numClasses != length(class_selected)){
          tempdf2 <- data.frame(class_selected)
          write.csv(tempdf2, file2)
        }
      } 
    
    
  })
  
  stopApp()
})  