# This program contains miscellaneous bits of code needed when running the app
## ---------------------------------------------------------------------------
## Helper Functions
## ---------------------------------------------------------------------------

target_mz <- function(x){
  y = as.numeric(rv$targets_mz[[1]][x])
  return(y)
}

target_in <- function(x){
  y = as.numeric(rv$targets_in[[1]][x])
  return(y)
}

output$ScoringTable <- DT::renderDataTable({
  
  Metric = c("&#916 <em>m/z</em>", 
             "Average FPIE (Fraction of Peak Intensity Explained)",
             "Average RevMF (Reverse Match Factor)",
             "Average spread",
             "LFPM Isotope Ratio Difference (IRD) 
             (Low Fragmentation Protonated Molecule)"
  )
  Description = c("mass difference between the observed target <em>m/z</em> 
                  and the calculated library reference <em>m/z</em>",
                  
                  "The fraction of total peak intensity from the library 
                  spectrum that have a 'matching' peak in the corresponding 
                  mixture spectrum, where matching implies a peak in the 
                  mixture spectrum within a mass tolerance window (&plusmn2&#949) 
                  and with signal intensity above the noise threshold. 
                  The reported number is a simple arithmetic average computed 
                  based on number of available fragmentation spectra compared.",
                  
                  "The cosine similarity between the vector constructed of 
                  relative intensities above the noise threshold from the 
                  library spectra and the vector constructed with relative 
                  intensities from 'matching' in the corresponding mixture 
                  spectrum, where matching implies the peak in the mixture 
                  closest (in <em>m/z</em>) to the library spectrum within a 
                  mass tolerance window (&plusmn2&#949). Note that the vector 
                  representing the mixture could have zero valued entries. 
                  The reported number is a simple arithmetic average computed 
                  based on number of available fragmentation spectra compared.",
                  
                  "The spread between the largest and smallest <em>m/z</em> 
                  differences observed between reference spectrum peaks and 
                  'matching' peaks in the mixture spectrum, where matching 
                  implies the mixture closest (in <em>m/z</em>) to the 
                  reference peak. If there are less than two matching peaks 
                  between the reference and mixture, the spread is reported as 
                  NA. The reported number is a simple arithmetic average 
                  computed based on number of available fragmentation spectra 
                  compared.",
                  
                  "The difference in calculated relative intensity isotope 
                  ratio (<sup>(M+i)</sup>&frasl;<sub>M</sub>) 
                  between the reference protonated molecule 
                  and its major isotope (i=1 or i=2) and the observed 
                  intensity values in the matching peaks in the mixture 
                  spectrum, where matching implies a peak in the mixture 
                  spectrum within a mass tolerance window (&plusmn&#949) and with 
                  signal intensity above the noise threshold. If there is no 
                  peak matching the protonated molecule in the mixture 
                  spectrum, the LFPM Isotope Ratio Difference is reported 
                  as NA."
  )
  
  Range = c("[-&#949, +&#949]",
            "[0,1]",
            "[0,1]",
            "[0,4&#949]",
            "[-9.99, +9.99]"
            )
  
  Ideal = c(0,1,1,0,0)
  
  df = data.frame(Metric, Description, Range, Ideal)
  
  return(df)
}, 
  escape = FALSE,
  rownames = FALSE,
  colnames = c("Metric", "Description", "Output Range", "Ideal Output"),
  options = list(
    dom = 't',
    ordering = F,
    autowidth = TRUE,
    columnDefs = list(list(className = 'dt-center', targets = c(0, 2, 3)),
                      list(width = '80px', targets = c(2))
                      )
  )
)



remindermsg = "Please select unique query spectra and re-search"

output$ErrorSameFilec0 <- renderText({
  hide("ErrorSameFilec0")
  HTML(paste0("Error: All files are identical: Low (30 V), Mid (60 V), and High (90 V).<br>",
        remindermsg))
})

output$ErrorSameFilec1 <- renderText({
  hide("ErrorSameFilec1")
  HTML(paste0("Error: Two identical files provided: Low (30 V) and Mid (60 V).<br>",
       remindermsg))
})

output$ErrorSameFilec2 <- renderText({
  hide("ErrorSameFilec2")
  HTML(paste0("Error: Two identical files provided: Low (30 V) and High (90 V).<br>",
        remindermsg))
})

output$ErrorSameFilec3 <- renderText({
  hide("ErrorSameFilec3")
  HTML(paste0("Error: Two identical files provided: Mid (60 V) and High (90 V).<br>",
        remindermsg))
})

output$ErrorNoFile <- renderText({
  hide("ErrorNoFile")
  "Error: Please provide at least a Low (30 V) Spectrum file upload."
})

output$Required <- renderText({
  "* required"
})
