## =============================================================================

# TITLE: Advanced_Settings.R

# DESCRIPTION: 
# Contains search settings for search tab of DIT. 
# If a search setting is not defined here, then the inputs/variables referencing 
# that setting are listed below to find elsewhere within the source code.
# Use [Ctrl+Shift+F] to search for input across all programs

# TABLE OF CONTENTS: 
# 1) SEARCH MODE 
#     - Pure Compound or Mixture Analysis
# 2) TARGET ASSUMPTION 
#     - De/Protonated Molecule or Base Peak
# 3) TARGET DISPLAY 
#     - Display only targets with potential matches? Y / N
# 4) TARGETTING THRESHOLD (%)
#     - Range 0 - 100
# 5) M/Z TOLERANCE (+/- DA)
#     - Integer Resolution Spectrum? Y / N
#     - Range 0 - 0.1


## =============================================================================
## 1) SEARCH MODE
## =============================================================================

#     - input$searchType
#     - rv$search_type
#     - Updated when trigger button clicked 

# Disable target_min_ab if Pure compound selected
# observeEvent(input$searchType,{
#   if(input$searchType == "pc"){
#     shinyjs::disable("target_min_ab")
#     rv$target_min_ab = 1
#   } else {
#     shinyjs::enable("target_min_ab")
#   }
# }) 

## =============================================================================
## 2) TARGET ASSUMPTION 
## =============================================================================

#     - input$target_type 
#     - init_targetType defined in asm_Header.R and elsewhere


## =============================================================================
## 3) TARGET DISPLAY 
## =============================================================================

observeEvent(input$hideTargets,{
  
  if(input$hideTargets==TRUE){
    rv$hideTargets = TRUE
  } else {
    rv$hideTargets = FALSE
  }
})

## =============================================================================
## 4) TARGETTING THRESHOLD (%)
## =============================================================================

# Set the target_min_ab for the shiny app
observeEvent(input$target_min_ab,{
  rv$target_min_ab = input$target_min_ab/100; #converts to a fraction for processing purposes
  
  # Future work for color changing button
  # output$DartSearchAdv <- renderUI({
  #   actionButton("DartSearchAdv", "Update Search",
  #                style = 'padding:10px; font-size:120%;
  #        color: white; background-color: #428BCA;
  #        border-color: #95A5A6')
  # })
})

# Change button color back
# output$DartSearchAdv <- renderUI({
#   
#   actionButton("DartSearchAdv", "Update Search",
#                style = 'padding:10px; font-size:120%;
#        color: white; background-color: #3E668E;
#        border-color: #2C3E50')
# })


## =============================================================================
## 5) M/Z TOLERANCE (+/- DA)
## =============================================================================

# Update rv epsilon
observeEvent(input$epsilon_0,{
  rv$mz_tol = input$epsilon_0
})


# Advanced setting parameter to respond to input for lowres
observeEvent(input$lowres,{
  # if lowres selected, disable input#epsilon_0 slider and set to 1
  if(input$lowres==TRUE){
    shinyjs::disable("epsilon_0")
    rv$mz_tol = 1
    updateSliderInput(session, "epsilon_0", value = 1)
    
  } else {
    shinyjs::enable("epsilon_0")
    rv$mz_tol = input$epsilon_0
  }
})

