sst_GUI_SCORING <- tabPanel(
  "Scoring",
  # titlePanel(h1("Overview on the Inverted Library Search Algorithm (ILSA)
  # Function, Scoring, and Metrics")),
  #            style = "color:black;font-size:1pt",
  
  # h1(id = "big-heading", 
  # "Overview on the Inverted Library Search Algorithm (ILSA)), Function, 
  # Scoring, and Metrics"),
  # tags$style(HTML("#big-heading {
  #                 color: black;
  #                 font-size: 24px;
  #                 font-style: bold;
  #                 }"))
  
  fluidRow(column(1),
           column(10, align="left",
                  
                  h3(strong("Overview on the Inverted Library Search Algorithm 
                  (ILSA) Function, Scoring, and Metrics")),
                  br(),
                  p(style="text-align:justify; color: black;font-size: 16px",
                  HTML(
                    "This section provides a brief overview of how the inverted
                    library search algorithm (ILSA) works and what the various 
                    scores and metrics represent. For a more detailed 
                    description of the ILSA please see the references at the 
                    end of this page.")),
                  br(),
                  
                  
                  h3(strong("How the ILSA works")),
                  p(style="text-align:justify; color: black;font-size: 16px",
                  HTML(
                    "The ILSA is a three-step process used to interpret one or 
                    more mixture is-CID mass spectra using a library of pure 
                    compound is-CID mass spectra. The algorithm requires a 
                    low-fragmentation mixture is-CID mass spectrum and, as 
                    implemented here, can handle up to an additional two 
                    is-CID mass spectra (mid-fragmentation and high-
                    fragmentation). Given one or more query mass spectra, 
                    the ILSA steps are as follows:")),
                  br(),
                  
                  p(align="center", img(src="ILSA.png", width="90%")),
                  br(),
                  
                  p(style="font-size:18px",
                    HTML("<b>Step 1: Target Identification.</b>")),
                  p(style="text-align:justify; color: black;font-size: 16px",
                    HTML("In the first step, a set of target mass-to-charge ratios 
                    (<em>m/z</em>) in the low-fragmentation is-CID mass spectrum of the 
                    mixture are identified by locating all peaks with relative 
                    intensities greater than the user-defined threshold. Each 
                    of these target <em>m/z</em> values are considered representative 
                    of one or more potential components in the mixture."
                  )),
                  br(), br(),
                  
                  p(style="font-size:18px",
                    HTML("<b>Step 2: Compound Matching.</b>")),
                  p(style="text-align:justify; color: black;font-size: 16px",
                  HTML(
                    "Potential library matches are identified by comparing each 
                    target <em>m/z</em> value identified in Step 1 with <em>m/z</em> values for 
                    all compounds in the library. The <em>m/z</em> values from the 
                    library entries used for comparison are the protonated 
                    molecule, the base peak (if different than the protonated 
                    molecule), the major fragment ion, and the major isotopes 
                    of the protonated molecule and the base peak. In order for 
                    a potential library match to be identified the target <em>m/z</em> 
                    value and the calculated <em>m/z</em> value from the library must 
                    be within the user-defined mass tolerance of one another 
                    (e.g., \u00B10.005 Da). Matching of major fragment ions or 
                    major isotopes only occurs if a protonated molecule or 
                    base peak of the compound are also identified."
                  )),
                  br(), br(),
                  
                  p(style="font-size:18px",
                    HTML("<b>Step 3: Compound Scoring.</b>")),
                  p(style="text-align:justify; color: black;font-size: 16px",
                  HTML(
                    "The is-CID mass spectra for each library compound 
                    identified as a potential match in Step 2, are compared to 
                    the query spectra and several scores and metrics are 
                    generated. With the ILSA, scoring is completed by 
                    comparing how well the library spectra are explained by 
                    matching peaks in the query spectra instead of the 
                    traditional approach which characterizes how well the 
                    query spectra are explained by the library entry. In this 
                    implementation two scores, and two metrics are generated 
                    for each comparison to assist users in interpreting the 
                    data. Details about the scores and metrics are provided 
                    in the table below. There are several nuances to the 
                    scoring process that users should be aware of:"
                  )),
                  div(p(
                    HTML(
                      "<ul><li>
                    A 1 % relative intensity noise cutoff is used for both 
                    the query and library spectra leading to peaks below 1 % 
                    relative intensity not being used in scoring.
                    </li><li>
                    To account for potential opposing mass drift differences 
                    between library and query spectra, peak matching in Step 3 
                    utilizes a window twice as wide as the user defined mass 
                    tolerance for high resolution (non-integer) measurements.
                    </li><li>
                    Because the current library has a low <em>m/z</em> cutoff at <em>m/z</em> 80, 
                    query peaks below <em>m/z</em> 80 are not used in scoring, 
                    regardless of relative intensity.
                    </li><li>
                    To prevent scoring with unexplained high mass peaks in 
                    library spectra, a high <em>m/z</em> cutoff 5 mass units above the 
                    protonated molecule is employed. This value ensures that 
                    the major ions of the protonated molecules isotopic 
                    window are considered in scoring.
                    </li>"
                    ), style = "text-align:justify; color: black;font-size: 16px")),
                  br(),
                  
                  h3(strong("Scores and metrics")),
                  p(style="text-align:justify; color: black;font-size: 16px",
                  HTML(
                    "The ILSA provides users with two scores and two metrics 
                    for every comparison between a set of query spectra and a 
                    library entry. The table below outlines what these scores 
                    and metrics are, what the possible range of values could 
                    be, and what an \"ideal\" value would be. Ideal is defined 
                    as a perfect match between a set of query and library 
                    spectra."
                  )),
                  br(),
                  
                  p(style="text-align:justify; color: black;font-size: 16px",
                    HTML("<b>Table 1:</b>
                         <em>Summary of scoring metrics produced by the 
                         updated ILSA. Values for mass tolerance (&#949) are 
                         prescribed by user for high-resolution mode, and 
                         &#949=0 for low-resolution mode.</em>")),
                  br(),
                  DT::dataTableOutput("ScoringTable"),
                  br(), br(), br()
                  
           ) # End column
  ) # End fluidRow
) # End tabPanel

