## =============================================================================

# TITLE: asm_GUI_LB.R

# DESCRIPTION: 
    # This program is future work for library building

## =============================================================================

    sst_GUI_DATABASE <- tabPanel(
      "Database Viewer" ,
      
      h3(strong("Search History")),
      br(),
      sidebarPanel(shinyjs::useShinyjs(),
        id = "dbsidebarpanel", width = 12,
        tabsetPanel(
        tabPanel("Navigator",
                 br(),
        
        fluidRow(
          column(5, 
                 fileInput("dbfileselect", "Change Database:",
                           multiple = FALSE,
                           placeholder = "Select file...",
                           accept = c(".sqlite")),
                 textInput("newdbname", label = "Create a new database",
                            placeholder = "Enter a name..."),
                 br(), br(),
                 actionButton("dbUpdate", "Update Selection")
          ),
          column(7,
                 checkboxInput("dbOnOff",
                               label = "Archive incoming search results?",
                               value = TRUE
                 ),
                 br(),
                 br(),
          )
        )
        ),
        
        tabPanel("Modify entries", br(),
                 fluidRow(
                   column(6,
                          div(uiOutput("ActiveDbSelection"),
                              style = "color:black; font-size:12pt"),
                          br(),
                          checkboxInput("dbdeleteselection", 
                                        label = "Delete", 
                                        value = FALSE),
                          br(),
                          textInput("dbrenameselection", label = "Rename selection"),
                          br(),
                          actionButton("modifydbentry", label = "Update Database")
                          )
    
                 )
        )
        )
      ),
      
      div(uiOutput("ActiveDatabase"),
          style = "color:black; font-size:12pt"),
      br(),
      DT::dataTableOutput("idtable"),
      # uiOutput("idtable"),
      
      br(),
      
                      
      # br(),
      # DT::dataTableOutput("QuerySelected"),
      # br(),
      # plotOutput("DBTestPlot",height="350px")
      # 
      
      # The following are expanded view plots and targets 
      fluidRow(column(8, plotOutput("DBTestPlot", height="350px")), 
               br(),
               column(4, 
                      # textOutput("peakListTitle1"), br(),
                      div(DT::dataTableOutput("PeakList_30v_db"), 
                          style = "width:300px;font-size:9pt"),
                      tags$head(tags$style(type="text/css", 
                                           "#PeakList_30v_db table td {line-height:40%;}"))
                      
               )
      ),
    )