## =============================================================================

# TITLE: asm_sst_GUI_DST.R

# DESCRIPTION: 
  # This program defines the UI for the Data search tab of the DART-MS Search
  # software. Users can use this tab to upload query spectra and search the 
  # reference libraries, as well as toggle between printer friendly and
  # interactive views of the data.

## =============================================================================

    asm_GUI_DST <- tabPanel(
      "Search Tool",
      fluidRow(
               radioButtons("toggle_DST", "View: ",
                            choices = c("Interactive", "Reporting"),
                            selected = "Interactive", inline = TRUE
               ),
               style = "color:black;font-size:12pt",
               align = "center"
      ), 
      br(),
      
      # Blank text entry fields
      fluidRow(
        id = "textfieldrow",
        column(2,
               textInput("entry1", 
                         label = "", value = entry1,
                         placeholder = "Date...")),
        column(3,
               textInput("entry2", 
                         label = "", value = entry2,
                         placeholder = "Instrument ID...")),
        column(3, 
               textInput("entry3", 
                         label = "", value = entry3,
                         placeholder = "Case No...")),
        column(3,
               textInput("entry4",
                         label = "", value = entry4,
                         placeholder = "Item No..."))
      ), 
      
      
      # Blank text entry fields for comments and reset button
      # actionButton(input$tag, frontend title)
      fluidRow(
        id = "commentrow",
        column(4,
               textInput("entry5", 
                         label = "", value = entry5,
                         placeholder = "Comments...")),
        div(style = "margin-top:+20px"),
        column(2,
               actionButton(inputId="file","Load Presets",
                            style = "width:170px")),
        column(2,
               downloadButton("downloadData", label = "Download Presets")),
        column(1,
               actionButton("resetEntries", "Restore Defaults"))
      ), 
      br(),
      
      # Output all fields for expanded view (hidden when interactive)
      fluidRow(
        id = "fields_table",
        tableOutput("fields"),
      ),
      br(),
      
      # Side bar for file inputs and DartSearch (trigger_butotn.R eventReactive)
      sidebarPanel(shinyjs::useShinyjs(),
       id = "side-panel",
       # Panel for file inputs of 3 query spectra
       #div(selectInput("RefLibSelect","Reference Library: ",choices=Libraries)),
       tabsetPanel(id = "tabSwitch_DST",
         tabPanel("Query Spectra", 
                  br(),
                  div(selectInput("RefLibSelect_DST", 
                                  "Reference Library: ",
                                  choices = Libraries,
                                  selected = rv_RefLibSelected),
                      style = "color:black"),
                  div(uiOutput("RefLibDescriptors"),
                      style = "color:black; margin-top:-20px"),
                  br(),
                  # div(selectInput("ClassesSelect", 
                  #                 "Search by Class: ",
                  #                 choices = classesTable,
                  #                 selected = class_selected,
                  #                 multiple = TRUE,
                  #                 ),
                  # style = "color:black"),
                  # actionButton("ClearClasses", "Clear all", 
                  #              style='margin-top:-25px; 
                  #              padding:4px; font-size:80%'),
                  # br(), br(),
                  div(p("Select centroided mass spectrum (txt, jsp, csv)
                        measured at fragmentation levels of your choice.
                        Low (30 V) fragmentation required. "
                  ),
                  style = "color:black;font-size:10pt"
                  ),
                  # File inputs for 3 file types
                  fileInput("q30","",
                            multiple = FALSE,
                            placeholder = "Low (30 V) Spectrum",
                            accept = query_file_types
                  ),
                  div(style = "margin-top:-25px"),
                  textOutput("Required"), style = "color:red",
                  fileInput("q60","",
                            multiple = FALSE,
                            placeholder = "Mid (60 V) Spectrum",
                            accept = query_file_types
                  ),
                  div(style = "margin-top:-25px"),
                  fileInput("q90", "",
                            multiple = FALSE,
                            placeholder = "High (90 V) Spectrum",
                            accept = query_file_types
                  ),
                  br(), br(),
                  # Action button DartSearch prompts trigger_button.R
                  actionButton("DartSearch", "Search Library",
                               style = 'padding:10px; font-size:120%; 
             color: white; background-color: #3E668E;
             border-color: #2C3E50'),
                  br(), br(),
                  
                  actionButton("clearSearch", "Clear Search"),
                  br(), br(), br(),
                  div(strong(p("References")),
                  p(HTML("Moorthy et. al. <a href='https://doi.org/10.26434/chemrxiv-2022-s00sl' target='_blank'>
           DOI:10.26434/chemrxiv-2022-s00sl</a>"
                      )),
                      p(HTML("Moorthy & Sisco. <a href='https://pubs.acs.org/doi/full/10.1021/jasms.1c00097' target='_blank'>
           DOI:10.1021/jasms.1c00097</a>"
                      )),
                      style = "color:black;font-size:8pt"
                  ),
         ), # End tab panel
         
         # Tab for advanced settings:
         # target_min_ab, target assumption, m/z tolerance (integer or not)
         tabPanel("Settings",

                  div(p(strong(HTML("Target Display: ")))),
                  checkboxInput("hideTargets",
                                label = "Display only targets with potential matches",
                                value = init_hideTargets),
                  br(),
                  sliderInput("target_min_ab",
                              label = "Targeting Threshold (%):",
                              min = 0, max = 100, 
                              value = init_tminab
                  ),
                  br(),
                  div(p(strong(HTML("<em>m/z</em> Tolerance (&#177 Da):")))),
                  shinyjs::useShinyjs(),
                  checkboxInput("lowres",
                                label = "Integer Resolution Spectrum",
                                value = init_lowres),
                  div(style = "margin-top:-25px"),
                  sliderInput("epsilon_0", label = "",
                              min = 0.000, 
                              max = 0.100, 
                              step = 0.001, 
                              value = init_epsilon
                  ),
                  br(), br(), 
                  # Second trigger_button.R button
                  # uiOutput("DartSearchAdv"),
                  actionButton("DartSearchAdv", "Update Search",
                               style = 'padding:10px; font-size:120%;
             color: white; background-color: #3E668E;
             border-color: #2C3E50'),
                  
         ) # End tab panel Advanced
       ) # End tabsetpanel
      ), # End sidebar panel
      # Main panel for plots and target information
      mainPanel(
        id = "mainPanelWarning",
        htmlOutput("ErrorSameFilec0"),
        htmlOutput("ErrorSameFilec1"),
        htmlOutput("ErrorSameFilec2"),
        htmlOutput("ErrorSameFilec3"),
        
        textOutput("ErrorNoFile"), style = "color:red"
      ),
      # Main panel for plots and target information
      mainPanel(
        id = "mainPanel_DST",
        fluidPage(
          # Interactive plot tabs UI and plots
          fluidRow(id = "UIRow",
                   column(8, uiOutput("QueryPlotsUI"))),
                   # column(4, uiOutput("peakListUI"))), 
          # br(),   
          fluidRow(column(8, plotlyOutput("QueryPlots",height="350px", width = "450px")),
                   column(3, id = "pl",
                          div(DT::dataTableOutput("interactivePeakList"), 
                              style = "width:250px;font-size:9pt;margin-top:-40px"), 
                          tags$head(tags$style(type="text/css", 
                               "#interactivePeakList table td {line-height:40%;}"))
                   )),
        ),
        
        fluidRow(id = "expanded_plot_row",
          # Print target information
          uiOutput("targetsUI"),
          uiOutput("interactiveTargets"),
          # uiOutput("targets_text"),
          
          # div(textOutput("Potentialmatches"),  style = "color:black;font-size:16pt"),
          DT::dataTableOutput("interactivetable"),
          br(),
          # The following are expanded view plots and targets 
          fluidRow(column(10, plotOutput("AllQueryPlots1", height="350px")), br(),
                   column(2, 
                          # textOutput("peakListTitle1"), br(),
                          div(DT::dataTableOutput("expandedPeakList1"), 
                              style = "width:190px;font-size:9pt"),
                          tags$head(tags$style(type="text/css", 
                                               "#expandedPeakList1 table td {line-height:40%;}"))
                              
                              )
          ),
          br(),
          fluidRow(column(10, plotOutput("AllQueryPlots2", height="350px")), br(),
                   column(2, 
                          # textOutput("peakListTitle2"), br(),
                          div(DT::dataTableOutput("expandedPeakList2"),
                              style = "width:190px;font-size:9pt"),
                          tags$head(tags$style(type="text/css", 
                                               "#expandedPeakList2 table td {line-height:40%;}"))
                              )
          ),
          br(),
          fluidRow(column(10, plotOutput("AllQueryPlots3", height="350px")), br(),
                   column(2, 
                          # textOutput("peakListTitle3"), br(),
                          div(DT::dataTableOutput("expandedPeakList3"),
                              style = "width:190px;font-size:9pt"),
                          tags$head(tags$style(type="text/css", 
                                               "#expandedPeakList3 table td {line-height:40%;}"))
                   )
          ),
          uiOutput("expandedTargets"),
          br(), br()
        ),
      )
    ) # End asm_GUI_DST