## =============================================================================

# TITLE: asm_GUI_DBV.R

# DESCRIPTION: 
  # The purpose of this program is to define the UI end of the shiny server app.
  # This program specifically defines the Libraries tab where users can search
  # through different reference libraries and retrieve spectra and structure 
  # information about different compounds. 

## =============================================================================
    
    asm_GUI_DBV <- tabPanel(
      "Libraries", id = "librarytab",
    
      fluidRow(
        radioButtons("toggle_DBV", "View: ", 
                     choices = c("Interactive", "Reporting"),
                     selected="Interactive",
                     inline = TRUE
                     ),
        style="color:black;font-size:12pt",
        align="center"
      ),
      br(),
      
      # Old Library orientation in comment blocks
      # Side bar panel for search
  
      # # Main panel for figures and table
      # mainPanel(
      #   id = "main-panel-DBV",
      #   # Row for table and structure
      #   fixedRow(
      #           column(7,div(tableOutput("LibraryData"),
      #                        style = "color:black;font-size:8pt")
      #                  ),
      #           column(2,
      #                  plotOutput("structurePlotter_plot",
      #                             height = "250px", width = "250px")
      #                  )
      #     ), # End row
      #   # Interactive tabs for query spectra
      #   fluidRow(id = "UI_DBV",
      #            column(8, uiOutput("LibraryPlotsUI")),
      #            column(4, uiOutput("peakListUI_DBV"))),
      #   br(),
      # fluidRow(column(8, plotlyOutput("LibraryPlot",height="350px")),
      # column(4,
      # tableOutput("interactivePeakList_DBV"),
      # tags$head(tags$style(type="text/css", "#interactivePeakList_DBV table td {line-height:40%;}"))
      #            )),
      # 
      #   # plotlyOutput("LibraryPlot", height = "350px"),
      #   # uiOutput("peakListUI_DBV"),
      #   # tableOutput("interactivePeakList_DBV"),
      #   # tags$head(tags$style(type="text/css", "#interactivePeakList_DBV table td {line-height:40%;}"))
      # ),
      
      mainPanel(
        id = "main-panel-DBV",
        fluidRow(
          column(width = 6, 
                 div(tableOutput("LibraryData"),
                        style = "color:black;font-size:10pt"
                        
                     )),
          column(width = 5, 
                 div(uiOutput("LibraryPlotsUI"),
                     style = 'width:450px'
                     # style='padding-left: 10px',
                 ),
                 plotlyOutput("LibraryPlot",height="350px", width = "450px")

                 ),
          
          
          tags$head(tags$style( HTML(' .test1 {padding-left:175px;margin-top:-90px;}'))),

          column(width = 1, #style='padding-left: 100px',
                 tags$div(
                   plotOutput("structurePlotter_plot",
                              height = "250px", width = "250px"),
                 # div(uiOutput("peakListUI_DBV"), style = 'width:200px; margin-top:-40px'), 
                 div(DT::dataTableOutput("interactivePeakList_DBV"), 
                     style = "width:250px;font-size:9pt;margin-top:-40px"),
tags$head(tags$style(type="text/css",
                     "#interactivePeakList_DBV table td {line-height:40%}")),
                 
                 class = 'test1'), br(), br(),
          ),
          
          # column(9, 
          #        fluidRow(column(3),
          #                 column(8, uiOutput("LibraryPlotsUI")),
                          # column(1, plotOutput("structurePlotter_plot",
                          #                      height = "250px", width = "250px"))
          #        ),
          #        fluidRow(
          #          column(7, plotlyOutput("LibraryPlot",height="350px", width = "450px")),
          #          column(5, uiOutput("peakListUI_DBV"))
          #        ),
          #        fluidRow(
          #          column(7),
                   # column(5, tableOutput("interactivePeakList_DBV"),
                   #        tags$head(tags$style(type="text/css",
                   #                             "#interactivePeakList_DBV table td {line-height:40%;}")))
          #        )
          # 
          # ),
          
        )
      ),
      
      br(), br(), br(), br(), br(),
      sidebarPanel(
        id = "side-panel-DBV", width = 12,
        div(selectInput("RefLibSelect", 
                        "Reference Library: ", 
                        choices = Libraries,
                        selected = rv_RefLibSelected
        )
        ),
        div(DT::dataTableOutput("Library"), style = "font-size:80%;"),
        div(strong(p("References")),
            p(HTML("Sisco et. al.<a href='https://pubs.acs.org/doi/abs/10.1021/jasms.0c00416' target='_blank'>
                       DOI:10.1021/jasms.0c00416</a>")
            ),
            style = "color:black;font-size:8pt"),
      ), 
      
      
      # Main panel for expanded view library plots
      mainPanel(
        # tags$head(tags$style( HTML(' .test2 {padding-left:175px;margin-top:-90px;}'))),
        
        id = "expanded-panel",
        plotOutput("structurePlotter_Reporting",
                   height = "250px", width = "250px"),
        
        # tags$div(
        fluidRow(column(8, plotOutput("allLibraryPlots1", height="350px")), br(),
                 column(4, 
                        div(DT::dataTableOutput("expandedPeakList1_DBV"),
                            style = "width:300px;font-size:9pt"),
                        tags$head(tags$style(type="text/css", 
                                             "#expandedPeakList1_DBV table td {line-height:40%;}")))
        ),
        br(),
        fluidRow(column(8, plotOutput("allLibraryPlots2", height="350px")), br(),
                 column(4, div(DT::dataTableOutput("expandedPeakList2_DBV"),
                               style = "width:300px;font-size:9pt"),
                        tags$head(tags$style(type="text/css", 
                                             "#expandedPeakList2_DBV table td {line-height:40%;}")))
        ),
        br(),
        fluidRow(column(8, plotOutput("allLibraryPlots3", height="350px")), br(),
                 column(4, div(DT::dataTableOutput("expandedPeakList3_DBV"),
                               style = "width:300px;font-size:9pt"),
                        tags$head(tags$style(type="text/css", 
                                             "#expandedPeakList3_DBV table td {line-height:40%;}")))
        # ),
        # class = 'test2'
        
        ),
        br()
      )
    ) #End asm_GUI_DBV