# This program calculates the absolute difference in m/z between the target and
# library protonated molecule (or base peak) subtracted from 1. This value is
# used to scale the computed scores. Large mass difference yield low function
# values that negatively affect computed score.

sst_mass_diff <- function(preMZ, tMZ){

  # when the mass calibration error is way off in the library, this can create undesirable results.
  # example 1X3X_30V.txt searched against Library v1.
  # mass_diff = abs( as.numeric(preMZ) - as.numeric(MCE) - as.numeric(tMZ) )

  mass_diff = ( as.numeric(tMZ) - as.numeric(preMZ))

  return(mass_diff)
}
