# This program controls query spectra file uploads using datapaths and string
# splitting. Currently allows for spectra in "jsp", "txt", and "csv" format.
# Allowing for other file types would require modifications in this function.

asm_specImport <- function(DataPath){

  filetype = strsplit(DataPath,"\\.")[[1]][2]

  if(filetype=="jsp"){
    data = readLines(DataPath)
    i.PeaksStart = grep("##DATA=",data)+1
    i.PeaksEnd = grep("##END=",data)-1
    PeakList = list(data[i.PeaksStart:i.PeaksEnd])
  } else if (filetype=="txt"){
    data = readLines(DataPath)
    a = NULL;
    for(i in 1:length(data)){
       b = strsplit(data[i],"")[[1]][1]
       if(is.na(suppressWarnings(as.numeric(b)))){
         a = c(a,i);
       } 
    }
    if(length(a)>0){
        data = data[-a]  
    }
    PeakList = list(data[1:length(data)])
  } else if (filetype=="csv"){
    rdata = readLines(DataPath)
    data = gsub(",","\t",rdata)
    PeakList = list(data[1:length(data)])
  }

  return(PeakList)

}
