## =============================================================================
## 
## NIST DART-MS Database Search Tool
## Web Application Code Base
##
## Edward R. Sisco; edward.sisco@nist.gov
## Arun S. Moorthy; arun.moorthy@nist.gov
##
## Version 0.3 (Library Version 0.5)
## Revision Date: Sept 19, 2020
## 
## =============================================================================

# TITLE: app.R 

# DESCRIPTION: 
    # The purpose of this program is to loada the asm_Header.R file, UI and 
    # server program, and then package into the shinyApp. 

# SUBDIRECTORIES: 
    # Libraries/ - NIST DART-MS Forensic Libraries used for search/viewing
    # source/ - Program functions and source code
    # www/ - contains logo img

## =============================================================================

## Load essential programs for app
    # Clear environment
    rm(list=ls())
    
    # load header file, UI, server
    source("source/asm_Header.R")
    source('source/asm_appUI.R', local = TRUE)
    source('source/asm_sst_appServer.R', local = TRUE)
  
  ## Package shiny app
    shinyApp(
      ui = appUI,
      server = appServer
    )